/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import io.agora.ValueCallBack;
import io.agora.chat.UserInfo;
import io.agora.chat.adapter.EMAError;
import io.agora.chat.adapter.EMAUserInfoManager;
import io.agora.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class UserInfoManager {
    static final String TAG = "UserInfoManager";
    EMAUserInfoManager emaObject;
    private ExecutorService executorService;

    protected UserInfoManager(EMAUserInfoManager manager) {
        this.emaObject = manager;
        this.executorService = Executors.newCachedThreadPool();
    }

    public void updateOwnInfo(final UserInfo userInfo, final ValueCallBack<String> callBack) {
        EMLog.d(TAG, "start updateOwnInfo");
        if (userInfo == null) {
            EMLog.d(TAG, "fetchUserInfoByUserId userInfo is empty");
            callBack.onError(205, "userInfo is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                JSONObject jSONObject = new JSONObject();
                try {
                    if (userInfo != null) {
                        jSONObject.putOpt(UserInfo.UserInfoType.NICKNAME.getDesc(), (Object)userInfo.getNickName());
                        jSONObject.putOpt(UserInfo.UserInfoType.AVATAR_URL.getDesc(), (Object)userInfo.getAvatarUrl());
                        jSONObject.putOpt(UserInfo.UserInfoType.EMAIL.getDesc(), (Object)userInfo.getEmail());
                        jSONObject.putOpt(UserInfo.UserInfoType.GENDER.getDesc(), (Object)userInfo.getGender());
                        jSONObject.putOpt(UserInfo.UserInfoType.BIRTH.getDesc(), (Object)userInfo.getBirth());
                        jSONObject.putOpt(UserInfo.UserInfoType.PHONE.getDesc(), (Object)userInfo.getPhoneNumber());
                        jSONObject.putOpt(UserInfo.UserInfoType.SIGN.getDesc(), (Object)userInfo.getSignature());
                        jSONObject.putOpt(UserInfo.UserInfoType.EXT.getDesc(), (Object)userInfo.getExt());
                    }
                    EMLog.d(UserInfoManager.TAG, "updateOwnInfo param: " + jSONObject.toString());
                    UserInfoManager.this.emaObject.updateOwnInfo(jSONObject.toString(), eMAError);
                    if (callBack == null) {
                        return;
                    }
                    if (eMAError.errCode() == 0) {
                        EMLog.d(UserInfoManager.TAG, "updateOwnInfo success");
                        callBack.onSuccess(eMAError.toString());
                    } else {
                        EMLog.e(UserInfoManager.TAG, "updateOwnInfo failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                        callBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
                catch (Exception exception) {
                    exception.getStackTrace();
                }
            }
        });
    }

    public void updateOwnInfoByAttribute(final UserInfo.UserInfoType attribute, final String value, final ValueCallBack<String> callBack) {
        EMLog.d(TAG, "start updateOwnInfoByAttribute");
        if (attribute == null) {
            EMLog.d(TAG, "fetchUserInfoByUserId attribute is null");
            callBack.onError(205, "attribute is null");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.putOpt(attribute.getDesc(), (Object)value);
                    EMLog.d(UserInfoManager.TAG, "updateOwnInfoByAttribute param: " + jSONObject.toString());
                    String string = UserInfoManager.this.emaObject.updateOwnInfo(jSONObject.toString(), eMAError);
                    EMLog.d(UserInfoManager.TAG, "updateOwnInfoByAttribute response: " + string);
                    if (callBack == null) {
                        return;
                    }
                    if (eMAError.errCode() == 0) {
                        EMLog.d(UserInfoManager.TAG, "updateOwnInfoByAttribute success");
                        callBack.onSuccess(string);
                    } else {
                        EMLog.e(UserInfoManager.TAG, "updateOwnInfoByAttribute failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                        callBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
                catch (Exception exception) {
                    exception.getStackTrace();
                }
            }
        });
    }

    public void fetchUserInfoByUserId(final String[] userIds, final ValueCallBack<Map<String, UserInfo>> callBack) {
        EMLog.d(TAG, "start fetchUserInfoByUserId");
        if (userIds == null || userIds.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId userIds is empty");
            callBack.onError(205, "userIds is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.addAll(arrayList, userIds);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(UserInfo.UserInfoType.NICKNAME.getDesc());
                arrayList2.add(UserInfo.UserInfoType.EMAIL.getDesc());
                arrayList2.add(UserInfo.UserInfoType.PHONE.getDesc());
                arrayList2.add(UserInfo.UserInfoType.GENDER.getDesc());
                arrayList2.add(UserInfo.UserInfoType.AVATAR_URL.getDesc());
                arrayList2.add(UserInfo.UserInfoType.SIGN.getDesc());
                arrayList2.add(UserInfo.UserInfoType.BIRTH.getDesc());
                arrayList2.add(UserInfo.UserInfoType.EXT.getDesc());
                EMLog.d(UserInfoManager.TAG, "fetchUserInfoByUserId param: " + ((Object)arrayList).toString() + "  " + ((Object)arrayList2).toString());
                String string = UserInfoManager.this.emaObject.fetchUserInfoByAttribute(arrayList, arrayList2, eMAError);
                if (callBack == null) {
                    return;
                }
                EMLog.d(UserInfoManager.TAG, "fetchUserInfoByUserId response: " + string);
                if (eMAError.errCode() == 0) {
                    EMLog.d(UserInfoManager.TAG, "fetchUserInfoByUserId success");
                    HashMap<String, UserInfo> hashMap = new HashMap<String, UserInfo>();
                    if (string != null && string.length() > 0) {
                        try {
                            JSONObject jSONObject = new JSONObject(string);
                            for (String string2 : userIds) {
                                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                                if (jSONObject2 == null) continue;
                                UserInfo userInfo = new UserInfo();
                                userInfo.setNickName(jSONObject2.optString(UserInfo.UserInfoType.NICKNAME.getDesc()));
                                String string3 = jSONObject2.optString(UserInfo.UserInfoType.GENDER.getDesc());
                                if (string3 != null && string3.length() > 0) {
                                    try {
                                        userInfo.setGender(Integer.parseInt(string3));
                                    }
                                    catch (Exception exception) {
                                        userInfo.setGender(0);
                                    }
                                }
                                userInfo.setEmail(jSONObject2.optString(UserInfo.UserInfoType.EMAIL.getDesc()));
                                userInfo.setPhoneNumber(jSONObject2.optString(UserInfo.UserInfoType.PHONE.getDesc()));
                                userInfo.setSignature(jSONObject2.optString(UserInfo.UserInfoType.SIGN.getDesc()));
                                userInfo.setAvatarUrl(jSONObject2.optString(UserInfo.UserInfoType.AVATAR_URL.getDesc()));
                                userInfo.setExt(jSONObject2.optString(UserInfo.UserInfoType.EXT.getDesc()));
                                userInfo.setBirth(jSONObject2.optString(UserInfo.UserInfoType.BIRTH.getDesc()));
                                userInfo.setUserId(string2);
                                hashMap.put(string2, userInfo);
                            }
                        }
                        catch (JSONException jSONException) {
                            eMAError.errMsg();
                        }
                        callBack.onSuccess(hashMap);
                    } else {
                        EMLog.e(UserInfoManager.TAG, "fetchUserInfoByUserId response is null");
                        callBack.onSuccess(null);
                    }
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                    EMLog.e(UserInfoManager.TAG, "fetchUserInfoByUserId failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                }
            }
        });
    }

    public void fetchUserInfoByAttribute(final String[] userIds, final UserInfo.UserInfoType[] attributes, final ValueCallBack<Map<String, UserInfo>> callBack) {
        EMLog.d(TAG, "start fetchUserInfoByAttribute");
        if (userIds == null || userIds.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId userIds is empty");
            callBack.onError(205, "userIds is empty");
            return;
        }
        if (attributes == null || attributes.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId attributes is empty");
            callBack.onError(205, "attributes is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.addAll(arrayList, userIds);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (UserInfo.UserInfoType stringArray : attributes) {
                    arrayList2.add(stringArray.getDesc());
                }
                EMLog.d(UserInfoManager.TAG, "fetchUserInfoByAttribute param: " + ((Object)arrayList).toString() + "  " + ((Object)arrayList2).toString());
                String string = UserInfoManager.this.emaObject.fetchUserInfoByAttribute(arrayList, arrayList2, eMAError);
                EMLog.d(UserInfoManager.TAG, "fetchUserInfoByAttribute response: " + (String)string);
                if (callBack == null) {
                    return;
                }
                if (eMAError.errCode() == 0) {
                    EMLog.d(UserInfoManager.TAG, "fetchUserInfoByAttribute success");
                    HashMap<String, UserInfo> hashMap = new HashMap<String, UserInfo>();
                    if (string != null && string.length() > 0) {
                        try {
                            JSONObject jSONObject = new JSONObject(string);
                            for (String string2 : userIds) {
                                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                                if (jSONObject2 == null) continue;
                                UserInfo userInfo = new UserInfo();
                                userInfo.setNickName(jSONObject2.optString(UserInfo.UserInfoType.NICKNAME.getDesc()));
                                String string3 = jSONObject2.optString(UserInfo.UserInfoType.GENDER.getDesc());
                                if (string3 != null && string3.length() > 0) {
                                    userInfo.setGender(Integer.valueOf(string3));
                                }
                                userInfo.setEmail(jSONObject2.optString(UserInfo.UserInfoType.EMAIL.getDesc()));
                                userInfo.setPhoneNumber(jSONObject2.optString(UserInfo.UserInfoType.PHONE.getDesc()));
                                userInfo.setSignature(jSONObject2.optString(UserInfo.UserInfoType.SIGN.getDesc()));
                                userInfo.setAvatarUrl(jSONObject2.optString(UserInfo.UserInfoType.AVATAR_URL.getDesc()));
                                userInfo.setExt(jSONObject2.optString(UserInfo.UserInfoType.EXT.getDesc()));
                                userInfo.setBirth(jSONObject2.optString(UserInfo.UserInfoType.BIRTH.getDesc()));
                                userInfo.setUserId(string2);
                                hashMap.put(string2, userInfo);
                            }
                        }
                        catch (JSONException jSONException) {
                            eMAError.errMsg();
                        }
                        callBack.onSuccess(hashMap);
                    } else {
                        EMLog.d(UserInfoManager.TAG, "fetchUserInfoByAttribute response is null ");
                        callBack.onSuccess(null);
                    }
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                    EMLog.e(UserInfoManager.TAG, "fetchUserInfoByAttribute failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                }
            }
        });
    }
}

