/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.os.Parcel;
import android.os.Parcelable;
import io.agora.chat.MessageBody;
import io.agora.chat.adapter.message.EMATextMessageBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TextMessageBody
extends MessageBody
implements Parcelable {
    public static final Parcelable.Creator<TextMessageBody> CREATOR = new Parcelable.Creator<TextMessageBody>(){

        public TextMessageBody createFromParcel(Parcel in) {
            return new TextMessageBody(in);
        }

        public TextMessageBody[] newArray(int size) {
            return new TextMessageBody[size];
        }
    };

    public TextMessageBody(String msg) {
        this.emaObject = new EMATextMessageBody(msg);
    }

    TextMessageBody(EMATextMessageBody body) {
        this.emaObject = body;
    }

    public String getMessage() {
        return ((EMATextMessageBody)this.emaObject).text();
    }

    public void setMessage(String message) {
        ((EMATextMessageBody)this.emaObject).setText(message);
    }

    public String toString() {
        return "txt:\"" + ((EMATextMessageBody)this.emaObject).text() + "\"";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMATextMessageBody)this.emaObject).text());
    }

    private TextMessageBody(Parcel in) {
        this.emaObject = new EMATextMessageBody(in.readString());
    }

    public void setTargetLanguages(List<String> languageList) {
        ((EMATextMessageBody)this.emaObject).setTargetLanguages(languageList);
    }

    public List<String> getTargetLanguages() {
        return ((EMATextMessageBody)this.emaObject).getTargetLanguages();
    }

    public List<TranslationInfo> getTranslations() {
        Map<String, String> map = ((EMATextMessageBody)this.emaObject).getTranslations();
        ArrayList<TranslationInfo> arrayList = new ArrayList<TranslationInfo>();
        for (String string : map.keySet()) {
            arrayList.add(new TranslationInfo(string, map.get(string)));
        }
        return arrayList;
    }

    public static class TranslationInfo {
        public String languageCode;
        public String translationText;

        public TranslationInfo(String languageCode, String translationText) {
            this.languageCode = languageCode;
            this.translationText = translationText;
        }
    }
}

