/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import io.agora.CallBack;
import io.agora.PresenceListener;
import io.agora.ValueCallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.Presence;
import io.agora.chat.adapter.EMAError;
import io.agora.chat.adapter.EMAPresence;
import io.agora.chat.adapter.EMAPresenceManager;
import io.agora.chat.adapter.EMAPresenceManagerListener;
import io.agora.util.EMLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PresenceManager {
    private final String TAG = this.getClass().getSimpleName();
    EMAPresenceManager emaObject;
    private List<PresenceListener> listeners = new CopyOnWriteArrayList<PresenceListener>();
    private EMAPresenceManagerListener listenerImpl = new EMAPresenceManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPresenceUpdated(List<EMAPresence> presences) {
            List list = PresenceManager.this.listeners;
            synchronized (list) {
                for (PresenceListener presenceListener : PresenceManager.this.listeners) {
                    try {
                        presenceListener.onPresenceUpdated(PresenceManager.this.convertToPresence(presences));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        EMLog.e(PresenceManager.this.TAG, "PresenceManager->listenerImpl:onPresenceUpdated() Error:" + exception.getMessage());
                    }
                }
            }
        }
    };

    public PresenceManager(EMAPresenceManager presenceManager) {
        this.emaObject = presenceManager;
        this.emaObject.addListener(this.listenerImpl);
    }

    public void publishPresence(final String ext, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                PresenceManager.this.emaObject.publishPresence(ext, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess();
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void subscribePresences(final List<String> members, final long expiry, final ValueCallBack<List<Presence>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<EMAPresence> list = PresenceManager.this.emaObject.subscribePresences(members, expiry, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess(PresenceManager.this.convertToPresence(list));
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void unsubscribePresences(final List<String> members, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                PresenceManager.this.emaObject.unsubscribePresences(members, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess();
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void fetchSubscribedMembers(final int pageNum, final int pageSize, final ValueCallBack<List<String>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<String> list = PresenceManager.this.emaObject.fetchSubscribedMembers(pageNum, pageSize, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess(list);
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void fetchPresenceStatus(final List<String> members, final ValueCallBack<List<Presence>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<EMAPresence> list = PresenceManager.this.emaObject.fetchPresenceStatus(members, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess(PresenceManager.this.convertToPresence(list));
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void addListener(PresenceListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(PresenceListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    private List<Presence> convertToPresence(List<EMAPresence> presences) {
        ArrayList<Presence> arrayList = new ArrayList<Presence>();
        for (int i = 0; i < presences.size(); ++i) {
            arrayList.add(new Presence(presences.get(i)));
        }
        return arrayList;
    }
}

