/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import io.agora.chat.EMBase;
import io.agora.chat.MucSharedFile;
import io.agora.chat.adapter.EMAGroup;
import io.agora.chat.adapter.EMAGroupSetting;
import io.agora.chat.adapter.EMAMucShareFile;
import java.util.ArrayList;
import java.util.List;

public class Group
extends EMBase<EMAGroup> {
    private List<MucSharedFile> shareFileList;

    public Group(EMAGroup group) {
        this.emaObject = group;
    }

    public String getGroupId() {
        return ((EMAGroup)this.emaObject).groupId();
    }

    public String getGroupName() {
        return ((EMAGroup)this.emaObject).groupSubject();
    }

    public String getDescription() {
        return ((EMAGroup)this.emaObject).getDescription();
    }

    public boolean isPublic() {
        EMAGroupSetting eMAGroupSetting = ((EMAGroup)this.emaObject).groupSetting();
        if (eMAGroupSetting == null) {
            return true;
        }
        switch (eMAGroupSetting.style()) {
            case 0: 
            case 1: {
                return false;
            }
        }
        return true;
    }

    public boolean isMemberAllowToInvite() {
        EMAGroupSetting eMAGroupSetting = ((EMAGroup)this.emaObject).groupSetting();
        if (eMAGroupSetting == null) {
            return true;
        }
        return eMAGroupSetting.style() == 1;
    }

    public boolean isMemberOnly() {
        EMAGroupSetting eMAGroupSetting = ((EMAGroup)this.emaObject).groupSetting();
        if (eMAGroupSetting == null) {
            return true;
        }
        return eMAGroupSetting.style() == 0 || eMAGroupSetting.style() == 1 || eMAGroupSetting.style() == 2;
    }

    public int getMaxUserCount() {
        EMAGroupSetting eMAGroupSetting = ((EMAGroup)this.emaObject).groupSetting();
        if (eMAGroupSetting == null) {
            return 0;
        }
        return eMAGroupSetting.maxUserCount();
    }

    public boolean isMsgBlocked() {
        return ((EMAGroup)this.emaObject).isMsgBlocked();
    }

    public String getOwner() {
        return ((EMAGroup)this.emaObject).getOwner();
    }

    public String groupSubject() {
        return ((EMAGroup)this.emaObject).groupSubject();
    }

    public List<String> getMembers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(((EMAGroup)this.emaObject).getMembers());
        return arrayList;
    }

    public int getMemberCount() {
        return ((EMAGroup)this.emaObject).getMemberCount();
    }

    public String toString() {
        String string = this.getGroupName();
        return string != null ? string : this.getGroupId();
    }

    public List<String> getAdminList() {
        return ((EMAGroup)this.emaObject).getAdminList();
    }

    public List<String> getBlackList() {
        return ((EMAGroup)this.emaObject).getGroupBans();
    }

    public List<String> getMuteList() {
        return ((EMAGroup)this.emaObject).getGroupMuteList();
    }

    public List<String> getWhiteList() {
        return ((EMAGroup)this.emaObject).getWhiteList();
    }

    public boolean isAllMemberMuted() {
        return ((EMAGroup)this.emaObject).isAllMemberMuted();
    }

    public String getExtension() {
        EMAGroupSetting eMAGroupSetting = ((EMAGroup)this.emaObject).groupSetting();
        if (eMAGroupSetting == null) {
            return "";
        }
        return eMAGroupSetting.extension();
    }

    public String getAnnouncement() {
        return ((EMAGroup)this.emaObject).getAnnouncement();
    }

    public List<MucSharedFile> getShareFileList() {
        if (this.shareFileList == null) {
            this.shareFileList = new ArrayList<MucSharedFile>();
        } else {
            this.shareFileList.clear();
        }
        List<EMAMucShareFile> list = ((EMAGroup)this.emaObject).getShareFiles();
        for (EMAMucShareFile eMAMucShareFile : list) {
            this.shareFileList.add(new MucSharedFile(eMAMucShareFile));
        }
        return this.shareFileList;
    }

    public GroupPermissionType getGroupPermissionType() {
        int n = ((EMAGroup)this.emaObject).permissionType();
        if (n == GroupPermissionType.member.permissionType) {
            return GroupPermissionType.member;
        }
        if (n == GroupPermissionType.admin.permissionType) {
            return GroupPermissionType.admin;
        }
        if (n == GroupPermissionType.owner.permissionType) {
            return GroupPermissionType.owner;
        }
        return GroupPermissionType.none;
    }

    public boolean isDisabled() {
        return ((EMAGroup)this.emaObject).isDisabled();
    }

    public static enum GroupPermissionType {
        member(0),
        admin(1),
        owner(2),
        none(-1);

        private int permissionType;

        private GroupPermissionType(int permissionType) {
            this.permissionType = permissionType;
        }
    }
}

