/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import io.agora.CallBack;
import io.agora.ContactListener;
import io.agora.ValueCallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.adapter.EMAContactListener;
import io.agora.chat.adapter.EMAContactManager;
import io.agora.chat.adapter.EMAError;
import io.agora.exceptions.ChatException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContactManager {
    EMAContactManager emaObject;
    ChatClient mClient;
    private List<ContactListener> contactListeners = Collections.synchronizedList(new ArrayList());
    private EMAContactListenerImpl contactImpl = new EMAContactListenerImpl();

    ContactManager(ChatClient client, EMAContactManager contactManager) {
        this.mClient = client;
        this.emaObject = new EMAContactManager(contactManager);
        this.emaObject.registerContactListener(this.contactImpl);
    }

    private void handleError(EMAError error) throws ChatException {
        if (error.errCode() != 0) {
            throw new ChatException(error);
        }
    }

    public void addContact(String username, String reason) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.inviteContact(username, reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddContact(final String username, final String reason, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ContactManager.this.addContact(username, reason);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void deleteContact(String username) throws ChatException {
        this.deleteContact(username, false);
    }

    public void deleteContact(String username, boolean keepConversation) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.deleteContact(username, eMAError, keepConversation);
        ChatClient.getInstance().chatManager().caches.remove(username);
        this.handleError(eMAError);
    }

    public void asyncDeleteContact(final String username, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ContactManager.this.deleteContact(username);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public List<String> getAllContactsFromServer() throws ChatException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getContactsFromServer(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetAllContactsFromServer(final ValueCallBack<List<String>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = ContactManager.this.getAllContactsFromServer();
                    callback.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void setContactListener(ContactListener contactListener) {
        if (!this.contactListeners.contains(contactListener)) {
            this.contactListeners.add(contactListener);
        }
    }

    public void removeContactListener(ContactListener contactListener) {
        this.contactListeners.remove(contactListener);
    }

    public void addUserToBlackList(String username, boolean both) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.addToBlackList(username, both, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddUserToBlackList(final String username, final boolean both, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ContactManager.this.addUserToBlackList(username, both);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void saveBlackList(List<String> blackList) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.saveBlackList(blackList, eMAError);
        this.handleError(eMAError);
    }

    public void asyncSaveBlackList(final List<String> blackList, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ContactManager.this.saveBlackList(blackList);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void removeUserFromBlackList(String username) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.removeFromBlackList(username, eMAError);
        this.handleError(eMAError);
    }

    public void asyncRemoveUserFromBlackList(final String username, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ContactManager.this.removeUserFromBlackList(username);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public List<String> getBlackListUsernames() {
        EMAError eMAError = new EMAError();
        return this.emaObject.getBlackListFromDB(eMAError);
    }

    public List<String> getBlackListFromServer() throws ChatException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getBlackListFromServer(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetBlackListFromServer(final ValueCallBack<List<String>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = ContactManager.this.getBlackListFromServer();
                    callback.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void acceptInvitation(String username) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.acceptInvitation(username, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAcceptInvitation(final String username, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ContactManager.this.acceptInvitation(username);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void declineInvitation(String username) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineInvitation(username, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineInvitation(final String username, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ContactManager.this.declineInvitation(username);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public List<String> getContactsFromLocal() throws ChatException {
        EMAError eMAError = new EMAError();
        List<String> list = this.getContactsFromDB(eMAError);
        this.handleError(eMAError);
        return list;
    }

    List<String> getContactsFromDB(EMAError error) {
        return this.emaObject.getContactsFromDB(error);
    }

    void onLogout() {
    }

    public List<String> getSelfIdsOnOtherPlatform() throws ChatException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.getSelfIdsOnOtherPlatform(eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetSelfIdsOnOtherPlatform(final ValueCallBack<List<String>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = ContactManager.this.getSelfIdsOnOtherPlatform();
                    callback.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    class EMAContactListenerImpl
    extends EMAContactListener {
        EMAContactListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactAdded(String username) {
            List list = ContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (ContactListener contactListener : ContactManager.this.contactListeners) {
                        contactListener.onContactAdded(username);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactDeleted(String username) {
            ChatClient.getInstance().chatManager().caches.remove(username);
            List list = ContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (ContactListener contactListener : ContactManager.this.contactListeners) {
                        contactListener.onContactDeleted(username);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactInvited(String username, String reason) {
            List list = ContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (ContactListener contactListener : ContactManager.this.contactListeners) {
                        contactListener.onContactInvited(username, reason);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactAgreed(String username) {
            List list = ContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (ContactListener contactListener : ContactManager.this.contactListeners) {
                        contactListener.onFriendRequestAccepted(username);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContactRefused(String username) {
            List list = ContactManager.this.contactListeners;
            synchronized (list) {
                try {
                    for (ContactListener contactListener : ContactManager.this.contactListeners) {
                        contactListener.onFriendRequestDeclined(username);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

