/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import io.agora.CallBack;
import io.agora.ChatThreadChangeListener;
import io.agora.ValueCallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.ChatMessage;
import io.agora.chat.ChatThread;
import io.agora.chat.ChatThreadEvent;
import io.agora.chat.CursorResult;
import io.agora.chat.adapter.EMAError;
import io.agora.chat.adapter.EMAThreadInfo;
import io.agora.chat.adapter.EMAThreadManager;
import io.agora.chat.adapter.EMAThreadManagerListener;
import io.agora.chat.adapter.message.EMAMessage;
import io.agora.exceptions.ChatException;
import io.agora.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChatThreadManager {
    private static String TAG = ChatThreadManager.class.getSimpleName();
    EMAThreadManager emaObject;
    ChatClient mClient;
    List<ChatThreadChangeListener> threadChangeListeners;
    private EMAThreadManagerListener listenerImpl = new EMAThreadManagerListener(){

        @Override
        public void onThreadNameUpdated(EMAThreadInfo event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveThread(EMAThreadInfo event, int reason) {
            List<ChatThreadChangeListener> list = ChatThreadManager.this.threadChangeListeners;
            synchronized (list) {
                for (ChatThreadChangeListener chatThreadChangeListener : ChatThreadManager.this.threadChangeListeners) {
                    try {
                        if (reason == EMAThreadInfo.LeaveReason.BE_KICKED.ordinal()) {
                            chatThreadChangeListener.onChatThreadUserRemoved(new ChatThreadEvent(event));
                            continue;
                        }
                        chatThreadChangeListener.onChatThreadDestroyed(new ChatThreadEvent(event));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void onMemberJoined(EMAThreadInfo event) {
        }

        @Override
        public void onMemberExited(EMAThreadInfo event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onThreadNotifyChange(EMAThreadInfo event) {
            List<ChatThreadChangeListener> list = ChatThreadManager.this.threadChangeListeners;
            synchronized (list) {
                for (ChatThreadChangeListener chatThreadChangeListener : ChatThreadManager.this.threadChangeListeners) {
                    try {
                        switch (event.getType()) {
                            case CREATE: {
                                chatThreadChangeListener.onChatThreadCreated(new ChatThreadEvent(event));
                                break;
                            }
                            case UPDATE: 
                            case UPDATE_MSG: {
                                chatThreadChangeListener.onChatThreadUpdated(new ChatThreadEvent(event));
                                break;
                            }
                            case DELETE: {
                                chatThreadChangeListener.onChatThreadDestroyed(new ChatThreadEvent(event));
                            }
                        }
                    }
                    catch (Exception exception) {
                        EMLog.e(TAG, exception.getMessage());
                    }
                }
            }
        }
    };

    ChatThreadManager(ChatClient client, EMAThreadManager threadManager) {
        this.emaObject = threadManager;
        this.mClient = client;
        this.threadChangeListeners = Collections.synchronizedList(new ArrayList());
        this.emaObject.addListener(this.listenerImpl);
        ChatClient.getInstance().chatManager();
    }

    public void addChatThreadChangeListener(ChatThreadChangeListener listener) {
        if (listener != null && !this.threadChangeListeners.contains(listener)) {
            this.threadChangeListeners.add(listener);
        }
    }

    public void removeChatThreadChangeListener(ChatThreadChangeListener listener) {
        if (listener != null && this.threadChangeListeners.contains(listener)) {
            this.threadChangeListeners.remove(listener);
        }
    }

    public void createChatThread(final String parentId, final String messageId, final String chatThreadName, final ValueCallBack<ChatThread> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatThread chatThread = ChatThreadManager.this.createChatThread(parentId, messageId, chatThreadName);
                    if (callBack != null) {
                        callBack.onSuccess(chatThread);
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "createChatThread error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private ChatThread createChatThread(String parentId, String messageId, String chatThreadName) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.createThread(parentId, messageId, chatThreadName, eMAError);
        this.handleError(eMAError);
        return new ChatThread(eMAThreadInfo);
    }

    public void getChatThreadFromServer(final String chatThreadId, final ValueCallBack<ChatThread> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatThread chatThread = ChatThreadManager.this.getChatThreadFromServer(chatThreadId);
                    if (callBack != null) {
                        callBack.onSuccess(chatThread);
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "getChatThreadFromServer error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private ChatThread getChatThreadFromServer(String chatThreadId) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.getThreadFromServer(chatThreadId, eMAError);
        this.handleError(eMAError);
        return new ChatThread(eMAThreadInfo);
    }

    public void joinChatThread(final String chatThreadId, final ValueCallBack<ChatThread> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatThread chatThread = ChatThreadManager.this.joinChatThread(chatThreadId);
                    if (callBack != null) {
                        callBack.onSuccess(chatThread);
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "joinChatThread error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private ChatThread joinChatThread(String chatThreadId) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.joinThread(chatThreadId, eMAError);
        this.handleError(eMAError);
        return new ChatThread(eMAThreadInfo);
    }

    public void destroyChatThread(final String chatThreadId, final CallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatThreadManager.this.destroyChatThread(chatThreadId);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "destroyChatThread error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private void destroyChatThread(String chatThreadId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyThread(chatThreadId, eMAError);
        this.handleError(eMAError);
    }

    public void leaveChatThread(final String chatThreadId, final CallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatThreadManager.this.leaveChatThread(chatThreadId);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "leaveChatThread error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private void leaveChatThread(String chatThreadId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.leaveThread(chatThreadId, eMAError);
        this.handleError(eMAError);
    }

    public void updateChatThreadName(final String chatThreadId, final String chatThreadName, final CallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatThreadManager.this.updateChatThreadName(chatThreadId, chatThreadName);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "changeChatThreadName error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private void updateChatThreadName(String chatThreadId, String chatThreadName) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.updateChatThreadName(chatThreadId, chatThreadName, eMAError);
        this.handleError(eMAError);
    }

    public void removeMemberFromChatThread(final String chatThreadId, final String member, final CallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatThreadManager.this.removeMemberFromChatThread(chatThreadId, member);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "removeMemberFromThread error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private void removeMemberFromChatThread(String chatThreadId, String member) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.removeMemberFromThread(chatThreadId, member, eMAError);
        this.handleError(eMAError);
    }

    public void getChatThreadMembers(final String chatThreadId, final int limit, final String cursor, final ValueCallBack<CursorResult<String>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CursorResult cursorResult = ChatThreadManager.this.getChatThreadMembers(chatThreadId, limit, cursor);
                    if (callBack != null) {
                        callBack.onSuccess(cursorResult);
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "getThreadMembers error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private CursorResult<String> getChatThreadMembers(String chatThreadId, int limit, String cursor) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<String> cursorResult = this.emaObject.fetchThreadMembers(chatThreadId, limit, cursor, eMAError);
        this.handleError(eMAError);
        return cursorResult;
    }

    public void getJoinedChatThreadsFromServer(final int limit, final String cursor, final ValueCallBack<CursorResult<ChatThread>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CursorResult cursorResult = ChatThreadManager.this.getJoinedChatThreadsFromServer(limit, cursor);
                    if (callBack != null) {
                        callBack.onSuccess(cursorResult);
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "getJoinedThreadsFromServer error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private CursorResult<ChatThread> getJoinedChatThreadsFromServer(int limit, String cursor) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<EMAThreadInfo> cursorResult = this.emaObject.getJoinedThreadsFromServer(limit, cursor, eMAError);
        this.handleError(eMAError);
        CursorResult<ChatThread> cursorResult2 = new CursorResult<ChatThread>();
        ArrayList<ChatThread> arrayList = new ArrayList<ChatThread>();
        List list = (List)cursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new ChatThread((EMAThreadInfo)list.get(i)));
        }
        cursorResult2.setData(arrayList);
        cursorResult2.setCursor(cursorResult.getCursor());
        return cursorResult2;
    }

    public void getJoinedChatThreadsFromServer(final String parentId, final int limit, final String cursor, final ValueCallBack<CursorResult<ChatThread>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CursorResult cursorResult = ChatThreadManager.this.getJoinedChatThreadsFromServer(parentId, limit, cursor);
                    if (callBack != null) {
                        callBack.onSuccess(cursorResult);
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "getJoinedThreadsFromServer error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private CursorResult<ChatThread> getJoinedChatThreadsFromServer(String parentId, int limit, String cursor) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<EMAThreadInfo> cursorResult = this.emaObject.getJoinedThreadsFromServer(parentId, limit, cursor, eMAError);
        this.handleError(eMAError);
        CursorResult<ChatThread> cursorResult2 = new CursorResult<ChatThread>();
        ArrayList<ChatThread> arrayList = new ArrayList<ChatThread>();
        List list = (List)cursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new ChatThread((EMAThreadInfo)list.get(i)));
        }
        cursorResult2.setData(arrayList);
        cursorResult2.setCursor(cursorResult.getCursor());
        return cursorResult2;
    }

    public void getChatThreadsFromServer(final String parentId, final int limit, final String cursor, final ValueCallBack<CursorResult<ChatThread>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CursorResult cursorResult = ChatThreadManager.this.getChatThreadsFromServer(parentId, limit, cursor);
                    if (callBack != null) {
                        callBack.onSuccess(cursorResult);
                    }
                }
                catch (ChatException chatException) {
                    if (callBack != null) {
                        callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                    }
                    EMLog.e(TAG, "getThreadsFromServer error: " + chatException.getErrorCode() + " " + chatException.getDescription());
                }
            }
        });
    }

    private CursorResult<ChatThread> getChatThreadsFromServer(String parentId, int limit, String cursor) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<EMAThreadInfo> cursorResult = this.emaObject.getThreadsFromServer(parentId, limit, cursor, eMAError);
        this.handleError(eMAError);
        CursorResult<ChatThread> cursorResult2 = new CursorResult<ChatThread>();
        ArrayList<ChatThread> arrayList = new ArrayList<ChatThread>();
        List list = (List)cursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new ChatThread((EMAThreadInfo)list.get(i)));
        }
        cursorResult2.setData(arrayList);
        cursorResult2.setCursor(cursorResult.getCursor());
        return cursorResult2;
    }

    public void getChatThreadLatestMessage(List<String> chatThreadIds, ValueCallBack<Map<String, ChatMessage>> callBack) {
        this.mClient.execute(() -> {
            block3: {
                Map<String, ChatMessage> map = null;
                try {
                    map = this.getChatThreadLatestMessage(chatThreadIds);
                    if (callBack != null) {
                        callBack.onSuccess(map);
                    }
                }
                catch (ChatException chatException) {
                    if (callBack == null) break block3;
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private Map<String, ChatMessage> getChatThreadLatestMessage(List<String> chatThreadIds) throws ChatException {
        EMAError eMAError = new EMAError();
        Map<String, EMAMessage> map = this.emaObject.getThreadsLatestMessage(chatThreadIds, eMAError);
        this.handleError(eMAError);
        HashMap<String, ChatMessage> hashMap = new HashMap<String, ChatMessage>();
        for (Map.Entry<String, EMAMessage> entry : map.entrySet()) {
            String string = entry.getKey();
            ChatMessage chatMessage = new ChatMessage(entry.getValue());
            hashMap.put(string, chatMessage);
        }
        return hashMap;
    }

    private void handleError(EMAError error) throws ChatException {
        if (error.errCode() != 0) {
            throw new ChatException(error);
        }
    }
}

