/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import io.agora.chat.ChatClient;
import io.agora.chat.EMBase;
import io.agora.chat.MessageStatistics;
import io.agora.chat.adapter.EMAMessageStatistics;
import io.agora.chat.adapter.EMAStatisticsManager;

public class ChatStatisticsManager
extends EMBase<EMAStatisticsManager> {
    ChatClient mClient;

    ChatStatisticsManager(ChatClient client, EMAStatisticsManager manager) {
        this.emaObject = manager;
        this.mClient = client;
    }

    public MessageStatistics getMessageStatistics(String messageId) {
        EMAMessageStatistics eMAMessageStatistics = ((EMAStatisticsManager)this.emaObject).getMsgStatistics(messageId);
        if (eMAMessageStatistics != null) {
            return new MessageStatistics(eMAMessageStatistics);
        }
        return null;
    }

    public int getMessageCount(long startTimestamp, long endTimestamp, SearchMessageDirect direct, SearchMessageType type) {
        return ((EMAStatisticsManager)this.emaObject).searchMsgStatisticsNumber(startTimestamp, endTimestamp, direct.getIndex(), type.getIndex());
    }

    public long getMessageSize(long startTimestamp, long endTimestamp, SearchMessageDirect direct, SearchMessageType type) {
        return ((EMAStatisticsManager)this.emaObject).searchMsgStatisticsSize(startTimestamp, endTimestamp, direct.getIndex(), type.getIndex());
    }

    boolean removeMessagesBeforeTime(long timestamp) {
        return ((EMAStatisticsManager)this.emaObject).removeMsgStatisticsBeforeTime(timestamp);
    }

    public static enum SearchMessageType {
        TXT(0),
        IMAGE(1),
        VIDEO(2),
        LOCATION(3),
        VOICE(4),
        FILE(5),
        CMD(6),
        CUSTOM(7),
        ALL(100);

        private final int index;

        private SearchMessageType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum SearchMessageDirect {
        SEND(0),
        RECEIVE(1),
        ALL(100);

        private final int index;

        private SearchMessageDirect(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

