/*
 * Decompiled with CFR 0.152.
 */
package inner.com.getkeepsafe.relinker;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import inner.com.getkeepsafe.relinker.MissingLibraryException;
import inner.com.getkeepsafe.relinker.ReLinker;
import inner.com.getkeepsafe.relinker.ReLinkerInstance;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ApkLibraryInstaller
implements ReLinker.LibraryInstaller {
    private static final int MAX_TRIES = 5;
    private static final int COPY_BUFFER_SIZE = 4096;

    private String[] sourceDirectories(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 21 && applicationInfo.splitSourceDirs != null && applicationInfo.splitSourceDirs.length != 0) {
            String[] stringArray = new String[applicationInfo.splitSourceDirs.length + 1];
            stringArray[0] = applicationInfo.sourceDir;
            System.arraycopy(applicationInfo.splitSourceDirs, 0, stringArray, 1, applicationInfo.splitSourceDirs.length);
            return stringArray;
        }
        return new String[]{applicationInfo.sourceDir};
    }

    private ZipFileInZipEntry findAPKWithLibrary(Context context, String[] abis, String mappedLibraryName, ReLinkerInstance instance) {
        for (String string : this.sourceDirectories(context)) {
            ZipFile zipFile = null;
            int n = 0;
            while (n++ < 5) {
                try {
                    zipFile = new ZipFile(new File(string), 1);
                    break;
                }
                catch (IOException iOException) {
                }
            }
            if (zipFile == null) continue;
            n = 0;
            while (n++ < 5) {
                String string2 = null;
                ZipEntry zipEntry = null;
                for (String string3 : abis) {
                    string2 = "lib" + File.separatorChar + string3 + File.separatorChar + mappedLibraryName;
                    instance.log("Looking for %s in APK %s...", string2, string);
                    zipEntry = zipFile.getEntry(string2);
                    if (zipEntry == null) continue;
                    return new ZipFileInZipEntry(zipFile, zipEntry);
                }
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private String[] getSupportedABIs(Context context, String mappedLibraryName) {
        String string = "lib" + File.separatorChar + "([^\\" + File.separatorChar + "]*)" + File.separatorChar + mappedLibraryName;
        Pattern pattern = Pattern.compile(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : this.sourceDirectories(context)) {
            ZipFile zipFile;
            try {
                zipFile = new ZipFile(new File(string2), 1);
            }
            catch (IOException iOException) {
                continue;
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                Matcher matcher = pattern.matcher(zipEntry.getName());
                if (!matcher.matches()) continue;
                hashSet.add(matcher.group(1));
            }
        }
        String[] stringArray = new String[hashSet.size()];
        return hashSet.toArray(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void installLibrary(Context context, String[] abis, String mappedLibraryName, File destination, ReLinkerInstance instance) {
        ZipFileInZipEntry zipFileInZipEntry = null;
        try {
            zipFileInZipEntry = this.findAPKWithLibrary(context, abis, mappedLibraryName, instance);
            if (zipFileInZipEntry == null) {
                String[] stringArray;
                try {
                    stringArray = this.getSupportedABIs(context, mappedLibraryName);
                }
                catch (Exception exception) {
                    stringArray = new String[]{exception.toString()};
                }
                throw new MissingLibraryException(mappedLibraryName, abis, stringArray);
            }
            int n = 0;
            while (n++ < 5) {
                instance.log("Found %s! Extracting...", mappedLibraryName);
                try {
                    if (!destination.exists() && !destination.createNewFile()) {
                    }
                }
                catch (IOException iOException) {}
                continue;
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    inputStream = zipFileInZipEntry.zipFile.getInputStream(zipFileInZipEntry.zipEntry);
                    fileOutputStream = new FileOutputStream(destination);
                    long l = this.copy(inputStream, fileOutputStream);
                    fileOutputStream.getFD().sync();
                    if (l != destination.length()) {
                        this.closeSilently(inputStream);
                        this.closeSilently(fileOutputStream);
                        continue;
                    }
                    this.closeSilently(inputStream);
                    this.closeSilently(fileOutputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.closeSilently(inputStream);
                    this.closeSilently(fileOutputStream);
                    continue;
                }
                catch (IOException iOException) {
                    this.closeSilently(inputStream);
                    this.closeSilently(fileOutputStream);
                    continue;
                    {
                        catch (Throwable throwable) {
                            this.closeSilently(inputStream);
                            this.closeSilently(fileOutputStream);
                            throw throwable;
                        }
                    }
                }
                destination.setReadable(true, false);
                destination.setExecutable(true, false);
                destination.setWritable(true);
                return;
            }
            instance.log("FATAL! Couldn't extract the library from the APK!");
        }
        finally {
            try {
                if (zipFileInZipEntry != null && zipFileInZipEntry.zipFile != null) {
                    zipFileInZipEntry.zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[4096];
        while ((n = in.read(byArray)) != -1) {
            out.write(byArray, 0, n);
            l += (long)n;
        }
        out.flush();
        return l;
    }

    private void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ZipFileInZipEntry {
        public ZipFile zipFile;
        public ZipEntry zipEntry;

        public ZipFileInZipEntry(ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }
    }
}

