/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.FailedConnectionException;
import io.ably.lib.network.HttpBody;
import io.ably.lib.network.HttpCall;
import io.ably.lib.network.HttpResponse;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpCall
implements HttpCall {
    private final Call call;

    public OkHttpCall(Call call) {
        this.call = call;
    }

    public HttpResponse execute() {
        HttpResponse httpResponse;
        block9: {
            Response response = this.call.execute();
            try {
                httpResponse = HttpResponse.builder().headers(response.headers().toMultimap()).code(response.code()).message(response.message()).body(this.buildHttpBody(response)).build();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ConnectException | NoRouteToHostException | SocketTimeoutException | UnknownHostException fce) {
                    throw new FailedConnectionException((Throwable)fce);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            response.close();
        }
        return httpResponse;
    }

    public void cancel() {
        this.call.cancel();
    }

    private HttpBody buildHttpBody(Response response) throws IOException {
        try (ResponseBody body = response.body();){
            MediaType contentType = body != null ? body.contentType() : null;
            HttpBody httpBody = contentType != null ? new HttpBody(contentType.toString(), body.bytes()) : null;
            return httpBody;
        }
    }
}

