/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.network;

import io.ably.lib.network.FailedConnectionException;
import io.ably.lib.network.HttpBody;
import io.ably.lib.network.HttpCall;
import io.ably.lib.network.HttpRequest;
import io.ably.lib.network.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class DefaultHttpCall
implements HttpCall {
    private final Proxy proxy;
    private final HttpRequest request;
    private HttpURLConnection connection;

    DefaultHttpCall(HttpRequest request, Proxy proxy) {
        this.request = request;
        this.proxy = proxy;
    }

    public HttpResponse execute() {
        URL url = this.request.getUrl();
        try {
            Object body;
            this.connection = (HttpURLConnection)url.openConnection(this.proxy);
            this.connection.setRequestMethod(this.request.getMethod());
            this.connection.setConnectTimeout(this.request.getHttpOpenTimeout());
            this.connection.setReadTimeout(this.request.getHttpReadTimeout());
            this.connection.setDoInput(true);
            for (Map.Entry entry : this.request.getHeaders().entrySet()) {
                String headerName = (String)entry.getKey();
                List values = (List)entry.getValue();
                for (String headerValue : values) {
                    this.connection.setRequestProperty(headerName, headerValue);
                }
            }
            if (this.request.getBody() != null) {
                body = this.prepareRequestBody(this.request.getBody());
                this.writeRequestBody((byte[])body);
            }
            body = this.readResponse();
            return body;
        }
        catch (ConnectException | NoRouteToHostException | SocketTimeoutException | UnknownHostException fce) {
            throw new FailedConnectionException((Throwable)fce);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.cancel();
        }
    }

    public void cancel() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private byte[] prepareRequestBody(HttpBody requestBody) throws IOException {
        this.connection.setDoOutput(true);
        byte[] body = requestBody.getContent();
        int length = body.length;
        this.connection.setFixedLengthStreamingMode(length);
        return body;
    }

    private void writeRequestBody(byte[] body) throws IOException {
        OutputStream os = this.connection.getOutputStream();
        os.write(body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse readResponse() throws IOException {
        HttpResponse.HttpResponseBuilder builder = HttpResponse.builder();
        int statusCode = this.connection.getResponseCode();
        builder.code(statusCode).message(this.connection.getResponseMessage());
        Map<String, List<String>> caseSensitiveHeaders = this.connection.getHeaderFields();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(caseSensitiveHeaders.size(), 1.0f);
        for (Map.Entry<String, List<String>> entry : caseSensitiveHeaders.entrySet()) {
            if (entry.getKey() == null) continue;
            headers.put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
        }
        builder.headers(headers);
        if (statusCode == 204) {
            return builder.build();
        }
        String contentType = this.connection.getContentType();
        int contentLength = this.connection.getContentLength();
        InputStream is = null;
        try {
            is = this.connection.getInputStream();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (is == null) {
            is = this.connection.getErrorStream();
        }
        try {
            byte[] body = this.readInputStream(is, contentLength);
            builder.body(new HttpBody(contentType, body));
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return builder.build();
    }

    private byte[] readInputStream(InputStream inputStream, int bytes) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream == null");
        }
        int bytesRead = 0;
        if (bytes == -1) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            return outputStream.toByteArray();
        }
        int idx = 0;
        byte[] output = new byte[bytes];
        while ((bytesRead = inputStream.read(output, idx, bytes - idx)) > -1) {
            idx += bytesRead;
        }
        return output;
    }
}

