/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.http.HttpCore;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class PublishResult {
    private static final String SERIALS = "serials";
    @Nullable
    public final String[] serials;

    public PublishResult(@Nullable String[] serials) {
        this.serials = serials;
    }

    private static PublishResult readFromJson(byte[] packed) throws MessageDecodeException {
        return (PublishResult)Serialisation.gson.fromJson(new String(packed), PublishResult.class);
    }

    private static PublishResult readMsgpack(byte[] packed) throws AblyException {
        try {
            MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(packed);
            return PublishResult.readMsgpack(unpacker);
        }
        catch (IOException ioe) {
            throw AblyException.fromThrowable(ioe);
        }
    }

    private static PublishResult readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (fieldName.equals(SERIALS)) {
                int count = unpacker.unpackArrayHeader();
                String[] serials = new String[count];
                for (int j = 0; j < count; ++j) {
                    if (unpacker.getNextFormat().equals((Object)MessageFormat.NIL)) {
                        unpacker.unpackNil();
                        serials[j] = null;
                        continue;
                    }
                    serials[j] = unpacker.unpackString();
                }
                return new PublishResult(serials);
            }
            unpacker.skipValue();
        }
        return new PublishResult(new String[0]);
    }

    static void writeMsgpackArray(PublishResult[] results, MessagePacker packer) {
        try {
            int count = results.length;
            packer.packArrayHeader(count);
            for (PublishResult result : results) {
                if (result != null) {
                    result.writeMsgpack(packer);
                    continue;
                }
                packer.packNil();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static PublishResult[] readMsgpackArray(MessageUnpacker unpacker) throws IOException {
        int count = unpacker.unpackArrayHeader();
        PublishResult[] results = new PublishResult[count];
        for (int i = 0; i < count; ++i) {
            results[i] = PublishResult.readMsgpack(unpacker);
        }
        return results;
    }

    public static HttpCore.BodyHandler<String> getBodyHandler() {
        return new PublishResultBodyHandler();
    }

    private void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = 0;
        if (this.serials != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if (this.serials != null) {
            packer.packString(SERIALS);
            packer.packArrayHeader(this.serials.length);
            for (String serial : this.serials) {
                if (serial == null) {
                    packer.packNil();
                    continue;
                }
                packer.packString(serial);
            }
        }
    }

    private static class PublishResultBodyHandler
    implements HttpCore.BodyHandler<String> {
        private PublishResultBodyHandler() {
        }

        public String[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            try {
                PublishResult publishResult = null;
                if ("application/json".equals(contentType)) {
                    publishResult = PublishResult.readFromJson(body);
                } else if ("application/x-msgpack".equals(contentType)) {
                    publishResult = PublishResult.readMsgpack(body);
                }
                return publishResult != null ? publishResult.serials : new String[]{};
            }
            catch (MessageDecodeException e) {
                throw AblyException.fromThrowable(e);
            }
        }
    }
}

