/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class MessageSerializer {
    private static HttpCore.BodyHandler<Message> messageResponseHandler = new MessageBodyHandler(null);
    private static final String TAG = MessageSerializer.class.getName();

    public static Message[] readMsgpackArray(MessageUnpacker unpacker) throws IOException {
        int count = unpacker.unpackArrayHeader();
        Message[] result = new Message[count];
        for (int i = 0; i < count; ++i) {
            result[i] = Message.fromMsgpack(unpacker);
        }
        return result;
    }

    public static Message[] readMsgpack(byte[] packed) throws AblyException {
        try {
            MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(packed);
            return MessageSerializer.readMsgpackArray(unpacker);
        }
        catch (IOException ioe) {
            throw AblyException.fromThrowable(ioe);
        }
    }

    public static HttpCore.RequestBody asSingleMsgpackRequest(Message message) throws AblyException {
        return new HttpUtils.ByteArrayRequestBody(MessageSerializer.write(message), "application/x-msgpack");
    }

    public static HttpCore.RequestBody asMsgpackRequest(Message[] messages) {
        return new HttpUtils.ByteArrayRequestBody(MessageSerializer.writeMsgpackArray(messages), "application/x-msgpack");
    }

    public static byte[] writeMsgpackArray(Message[] messages) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker((OutputStream)out);
            MessageSerializer.writeMsgpackArray(messages, packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void writeMsgpackArray(Message[] messages, MessagePacker packer) {
        try {
            int count = messages.length;
            packer.packArrayHeader(count);
            for (Message message : messages) {
                message.writeMsgpack(packer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] write(Message message) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker((OutputStream)out);
            message.writeMsgpack(packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void write(Map<String, String> map, MessagePacker packer) throws IOException {
        packer.packMapHeader(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            packer.packString(entry.getKey());
            packer.packString(entry.getValue());
        }
    }

    public static Map<String, String> readStringMap(MessageUnpacker unpacker) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            map.put(fieldName, unpacker.unpackString());
        }
        return map;
    }

    public static HttpCore.RequestBody asMsgpackRequest(Message.Batch[] pubSpecs) {
        return new HttpUtils.ByteArrayRequestBody(MessageSerializer.writeMsgpackArray(pubSpecs), "application/x-msgpack");
    }

    static byte[] writeMsgpackArray(Message.Batch[] pubSpecs) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker((OutputStream)out);
            MessageSerializer.writeMsgpackArray(pubSpecs, packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    static void writeMsgpackArray(Message.Batch[] pubSpecs, MessagePacker packer) throws IOException {
        try {
            int count = pubSpecs.length;
            packer.packArrayHeader(count);
            for (Message.Batch spec : pubSpecs) {
                spec.writeMsgpack(packer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Message[] readMessagesFromJson(byte[] packed) throws MessageDecodeException {
        return (Message[])Serialisation.gson.fromJson(new String(packed), Message[].class);
    }

    public static HttpCore.RequestBody asJsonRequest(Message message) throws AblyException {
        return MessageSerializer.asJsonRequest(new Message[]{message});
    }

    public static HttpCore.RequestBody asSingleJsonRequest(Message message) {
        return new HttpUtils.JsonRequestBody(Serialisation.gson.toJson((Object)message));
    }

    public static HttpCore.RequestBody asJsonRequest(Message[] messages) {
        return new HttpUtils.JsonRequestBody(Serialisation.gson.toJson((Object)messages));
    }

    public static HttpCore.RequestBody asJSONRequest(Message.Batch[] pubSpecs) {
        return new HttpUtils.JsonRequestBody(Serialisation.gson.toJson((Object)pubSpecs));
    }

    public static HttpCore.BodyHandler<Message> getMessageResponseHandler(ChannelOptions opts) {
        return opts == null ? messageResponseHandler : new MessageBodyHandler(opts);
    }

    public static HttpCore.BodyHandler<Message> getSingleMessageResponseHandler(ChannelOptions opts) {
        return new SingleMessageBodyHandler(opts);
    }

    private static class MessageBodyHandler
    implements HttpCore.BodyHandler<Message> {
        private ChannelOptions opts;

        MessageBodyHandler(ChannelOptions opts) {
            this.opts = opts;
        }

        public Message[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            try {
                Message[] messages = null;
                if ("application/json".equals(contentType)) {
                    messages = MessageSerializer.readMessagesFromJson(body);
                } else if ("application/x-msgpack".equals(contentType)) {
                    messages = MessageSerializer.readMsgpack(body);
                }
                if (messages != null) {
                    for (Message message : messages) {
                        try {
                            message.decode(this.opts);
                        }
                        catch (MessageDecodeException e) {
                            Log.e(TAG, e.errorInfo.message);
                        }
                    }
                }
                return messages;
            }
            catch (MessageDecodeException e) {
                throw AblyException.fromThrowable(e);
            }
        }
    }

    private static class SingleMessageBodyHandler
    implements HttpCore.BodyHandler<Message> {
        private final ChannelOptions opts;

        SingleMessageBodyHandler(ChannelOptions opts) {
            this.opts = opts;
        }

        public Message[] handleResponseBody(String contentType, byte[] body) throws AblyException {
            try {
                Message message = null;
                if ("application/json".equals(contentType)) {
                    message = (Message)Serialisation.gson.fromJson(new String(body), Message.class);
                } else if ("application/x-msgpack".equals(contentType)) {
                    MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(body);
                    try {
                        message = new Message().readMsgpack(unpacker);
                    }
                    catch (IOException ioe) {
                        throw AblyException.fromThrowable(ioe);
                    }
                }
                if (message != null) {
                    try {
                        message.decode(this.opts);
                    }
                    catch (MessageDecodeException e) {
                        Log.e(TAG, e.errorInfo.message);
                    }
                }
                return new Message[]{message};
            }
            catch (MessageDecodeException e) {
                throw AblyException.fromThrowable(e);
            }
        }
    }
}

