/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.realtime.ChannelBase;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.rest.RestAnnotations;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Annotation;
import io.ably.lib.types.AnnotationAction;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.Log;
import io.ably.lib.util.Multicaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RealtimeAnnotations {
    private static final String TAG = RealtimeAnnotations.class.getName();
    private final ChannelBase channel;
    private final RestAnnotations restAnnotations;
    private final AnnotationMulticaster listeners = new AnnotationMulticaster();
    private final Map<String, AnnotationMulticaster> typeListeners = new HashMap<String, AnnotationMulticaster>();

    public RealtimeAnnotations(ChannelBase channel, RestAnnotations restAnnotations) {
        this.channel = channel;
        this.restAnnotations = restAnnotations;
    }

    public void publish(String messageSerial, Annotation annotation, CompletionListener listener) throws AblyException {
        Log.v(TAG, String.format("publish(MsgSerial, Annotation); channel = %s", this.channel.name));
        this.validateMessageSerial(messageSerial);
        annotation.action = AnnotationAction.ANNOTATION_CREATE;
        this.sendAnnotation(messageSerial, annotation, listener);
    }

    public void publish(Message message, Annotation annotation, CompletionListener listener) throws AblyException {
        this.publish(message.serial, annotation, listener);
    }

    public void publish(String messageSerial, Annotation annotation) throws AblyException {
        this.publish(messageSerial, annotation, null);
    }

    public void publish(Message message, Annotation annotation) throws AblyException {
        this.publish(message.serial, annotation);
    }

    private void sendAnnotation(String messageSerial, Annotation annotation, CompletionListener listener) throws AblyException {
        if (annotation.type == null) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Annotation type must be specified", 400, 40000));
        }
        annotation.messageSerial = messageSerial;
        try {
            annotation.encode(this.channel.options);
        }
        catch (MessageDecodeException e) {
            throw AblyException.fromThrowable(e);
        }
        Log.v(TAG, String.format("RealtimeAnnotations.sendAnnotation(): channelName = %s, sending annotation with messageSerial = %s, type = %s, action = %s", this.channel.name, messageSerial, annotation.type, annotation.action.name()));
        ProtocolMessage protocolMessage = new ProtocolMessage();
        protocolMessage.action = ProtocolMessage.Action.annotation;
        protocolMessage.channel = this.channel.name;
        protocolMessage.annotations = new Annotation[]{annotation};
        this.channel.sendProtocolMessage(protocolMessage, listener);
    }

    public void delete(String messageSerial, Annotation annotation, CompletionListener listener) throws AblyException {
        Log.v(TAG, String.format("delete(MsgSerial, Annotation); channel = %s", this.channel.name));
        annotation.action = AnnotationAction.ANNOTATION_DELETE;
        this.sendAnnotation(messageSerial, annotation, listener);
    }

    public void delete(Message message, Annotation annotation, CompletionListener listener) throws AblyException {
        this.delete(message.serial, annotation, listener);
    }

    public void delete(String messageSerial, Annotation annotation) throws AblyException {
        this.delete(messageSerial, annotation, null);
    }

    public void delete(Message message, Annotation annotation) throws AblyException {
        this.delete(message.serial, annotation);
    }

    public PaginatedResult<Annotation> get(String messageSerial, Param[] params) throws AblyException {
        return this.restAnnotations.get(messageSerial, params);
    }

    public PaginatedResult<Annotation> get(Message message, Param[] params) throws AblyException {
        return this.get(message.serial, params);
    }

    public PaginatedResult<Annotation> get(String messageSerial) throws AblyException {
        return this.restAnnotations.get(messageSerial, null);
    }

    public PaginatedResult<Annotation> get(Message message) throws AblyException {
        return this.get(message.serial);
    }

    public void getAsync(String messageSerial, Param[] params, Callback<AsyncPaginatedResult<Annotation>> callback) throws AblyException {
        this.restAnnotations.getAsync(messageSerial, params, callback);
    }

    public void getAsync(Message message, Param[] params, Callback<AsyncPaginatedResult<Annotation>> callback) throws AblyException {
        this.getAsync(message.serial, params, callback);
    }

    public void getAsync(String messageSerial, Callback<AsyncPaginatedResult<Annotation>> callback) throws AblyException {
        this.restAnnotations.getAsync(messageSerial, null, callback);
    }

    public void getAsync(Message message, Callback<AsyncPaginatedResult<Annotation>> callback) throws AblyException {
        this.getAsync(message.serial, callback);
    }

    public synchronized void subscribe(AnnotationListener listener) throws AblyException {
        Log.v(TAG, String.format("subscribe(); annotations in channel = %s", this.channel.name));
        this.listeners.add(listener);
        if (this.channel.attachOnSubscribeEnabled()) {
            this.channel.attach();
        }
    }

    public synchronized void unsubscribe(AnnotationListener listener) {
        Log.v(TAG, String.format("unsubscribe(); annotations in channel = %s", this.channel.name));
        this.listeners.remove(listener);
        for (AnnotationMulticaster multicaster : this.typeListeners.values()) {
            multicaster.remove(listener);
        }
    }

    public synchronized void subscribe(String type, AnnotationListener listener) throws AblyException {
        Log.v(TAG, String.format("subscribe(); annotations in channel = %s; single type = %s", this.channel.name, type));
        this.subscribeImpl(type, listener);
        if (this.channel.attachOnSubscribeEnabled()) {
            this.channel.attach();
        }
    }

    public synchronized void unsubscribe(String type, AnnotationListener listener) {
        Log.v(TAG, String.format("unsubscribe(); annotations in channel = %s; single type = %s", this.channel.name, type));
        this.unsubscribeImpl(type, listener);
    }

    public void onAnnotation(ProtocolMessage protocolMessage) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < protocolMessage.annotations.length; ++i) {
            Annotation annotation = protocolMessage.annotations[i];
            try {
                if (annotation.data != null) {
                    annotation.decode(this.channel.options);
                }
            }
            catch (MessageDecodeException e) {
                Log.e(TAG, String.format(Locale.ROOT, "%s on channel %s", e.errorInfo.message, this.channel.name));
            }
            if (annotation.connectionId == null) {
                annotation.connectionId = protocolMessage.connectionId;
            }
            if (annotation.timestamp == 0L) {
                annotation.timestamp = protocolMessage.timestamp;
            }
            if (annotation.id == null) {
                annotation.id = protocolMessage.id + ':' + i;
            }
            annotations.add(annotation);
        }
        this.broadcastAnnotation(annotations);
    }

    private void validateMessageSerial(String messageSerial) throws AblyException {
        if (messageSerial == null) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Message serial can not be empty", 400, 40003));
        }
    }

    private void broadcastAnnotation(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            this.listeners.onAnnotation(annotation);
            String type = annotation.type != null ? annotation.type : "";
            AnnotationMulticaster eventListener = this.typeListeners.get(type);
            if (eventListener == null) continue;
            eventListener.onAnnotation(annotation);
        }
    }

    private void subscribeImpl(String type, AnnotationListener listener) {
        String annotationType = type != null ? type : "";
        AnnotationMulticaster typeSpecificListeners = this.typeListeners.get(annotationType);
        if (typeSpecificListeners == null) {
            typeSpecificListeners = new AnnotationMulticaster();
            this.typeListeners.put(annotationType, typeSpecificListeners);
        }
        typeSpecificListeners.add(listener);
    }

    private void unsubscribeImpl(String type, AnnotationListener listener) {
        AnnotationMulticaster listeners = this.typeListeners.get(type);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.typeListeners.remove(type);
            }
        }
    }

    private static class AnnotationMulticaster
    extends Multicaster<AnnotationListener>
    implements AnnotationListener {
        private AnnotationMulticaster() {
            super(new AnnotationListener[0]);
        }

        @Override
        public void onAnnotation(Annotation annotation) {
            for (AnnotationListener member : this.getMembers()) {
                try {
                    member.onAnnotation(annotation);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage(), e);
                }
            }
        }
    }

    public static interface AnnotationListener {
        public void onAnnotation(Annotation var1);
    }
}

