/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.types.AblyException;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.Serialisation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class ProtocolSerializer {
    public static ProtocolMessage readMsgpack(byte[] packed) throws AblyException {
        try {
            MessageUnpacker unpacker = Serialisation.msgpackUnpackerConfig.newUnpacker(packed);
            return ProtocolMessage.fromMsgpack(unpacker);
        }
        catch (IOException ioe) {
            throw AblyException.fromThrowable(ioe);
        }
    }

    public static byte[] writeMsgpack(ProtocolMessage message) throws AblyException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker((OutputStream)out);
        try {
            message.writeMsgpack(packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException ioe) {
            throw AblyException.fromThrowable(ioe);
        }
    }

    public static ProtocolMessage fromJSON(String packed) throws AblyException {
        return (ProtocolMessage)Serialisation.gson.fromJson(packed, ProtocolMessage.class);
    }

    public static byte[] writeJSON(ProtocolMessage message) throws AblyException {
        return Serialisation.gson.toJson((Object)message).getBytes(Charset.forName("UTF-8"));
    }
}

