/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.annotation.Experimental;
import io.ably.lib.http.AsyncHttpPaginatedQuery;
import io.ably.lib.http.AsyncHttpScheduler;
import io.ably.lib.http.AsyncPaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpPaginatedQuery;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.http.PaginatedQuery;
import io.ably.lib.http.SyncHttpScheduler;
import io.ably.lib.platform.Platform;
import io.ably.lib.push.Push;
import io.ably.lib.rest.Auth;
import io.ably.lib.rest.Channel;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncHttpPaginatedResponse;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.HttpPaginatedResponse;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PublishResponse;
import io.ably.lib.types.ReadOnlyMap;
import io.ably.lib.types.Stats;
import io.ably.lib.types.StatsReader;
import io.ably.lib.util.Crypto;
import io.ably.lib.util.InternalMap;
import io.ably.lib.util.Log;
import io.ably.lib.util.PlatformAgentProvider;
import io.ably.lib.util.Serialisation;

public abstract class AblyBase
implements AutoCloseable {
    private static final int LEGACY_API_PROTOCOL_V2 = 2;
    public final ClientOptions options;
    public final Http http;
    public final HttpCore httpCore;
    public final Auth auth;
    public final Channels channels;
    public final Platform platform;
    public final Push push;
    protected final PlatformAgentProvider platformAgentProvider;

    public AblyBase(String key, PlatformAgentProvider platformAgentProvider) throws AblyException {
        this(new ClientOptions(key), platformAgentProvider);
    }

    public AblyBase(ClientOptions options, PlatformAgentProvider platformAgentProvider) throws AblyException {
        if (options == null) {
            String msg = "no options provided";
            Log.e(this.getClass().getName(), msg);
            throw AblyException.fromErrorInfo(new ErrorInfo(msg, 400, 40000));
        }
        this.options = options;
        Log.setLevel(options.logLevel);
        Log.setHandler(options.logHandler);
        Log.i(this.getClass().getName(), "started");
        this.platformAgentProvider = platformAgentProvider;
        this.auth = new Auth(this, options);
        this.httpCore = new HttpCore(options, this.auth, this.platformAgentProvider);
        this.http = new Http(new AsyncHttpScheduler(this.httpCore, options), new SyncHttpScheduler(this.httpCore));
        this.channels = new InternalChannels();
        this.platform = new Platform();
        this.push = new Push(this);
    }

    @Override
    public void close() throws Exception {
        this.http.close();
    }

    protected void connect() {
        this.http.connect();
    }

    public long time() throws AblyException {
        return this.time(this.http);
    }

    long time(Http http) throws AblyException {
        return this.timeImpl(http).sync();
    }

    public void timeAsync(Callback<Long> callback) {
        this.timeAsync(this.http, callback);
    }

    void timeAsync(Http http, Callback<Long> callback) {
        this.timeImpl(http).async(callback);
    }

    private Http.Request<Long> timeImpl(Http http) {
        final Param[] params = this.options.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
        return http.request(new Http.Execute<Long>(){

            @Override
            public void execute(HttpScheduler http, Callback<Long> callback) throws AblyException {
                http.get("/time", HttpUtils.defaultAcceptHeaders(false), params, new HttpCore.ResponseHandler<Long>(){

                    @Override
                    public Long handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
                        if (error != null) {
                            throw AblyException.fromErrorInfo(error);
                        }
                        return ((Long[])Serialisation.gson.fromJson(new String(response.body), Long[].class))[0];
                    }
                }, false, callback);
            }
        });
    }

    public PaginatedResult<Stats> stats(Param[] params) throws AblyException {
        return this.stats(this.http, params);
    }

    PaginatedResult<Stats> stats(Http http, Param[] params) throws AblyException {
        return new PaginatedQuery<Stats>(http, "/stats", Param.set(HttpUtils.defaultAcceptHeaders(false), new Param("X-Ably-Version", 2)), params, StatsReader.statsResponseHandler).get();
    }

    public void statsAsync(Param[] params, Callback<AsyncPaginatedResult<Stats>> callback) {
        this.statsAsync(this.http, params, callback);
    }

    void statsAsync(Http http, Param[] params, Callback<AsyncPaginatedResult<Stats>> callback) {
        new AsyncPaginatedQuery<Stats>(http, "/stats", Param.set(HttpUtils.defaultAcceptHeaders(false), new Param("X-Ably-Version", 2)), params, StatsReader.statsResponseHandler).get(callback);
    }

    public HttpPaginatedResponse request(String method, String path, Param[] params, HttpCore.RequestBody body, Param[] headers) throws AblyException {
        return this.request(this.http, method, path, params, body, headers);
    }

    HttpPaginatedResponse request(Http http, String method, String path, Param[] params, HttpCore.RequestBody body, Param[] headers) throws AblyException {
        headers = HttpUtils.mergeHeaders(HttpUtils.defaultAcceptHeaders(false), headers);
        return new HttpPaginatedQuery(http, method, path, headers, params, body).exec();
    }

    public void requestAsync(String method, String path, Param[] params, HttpCore.RequestBody body, Param[] headers, AsyncHttpPaginatedResponse.Callback callback) {
        this.requestAsync(this.http, method, path, params, body, headers, callback);
    }

    void requestAsync(Http http, String method, String path, Param[] params, HttpCore.RequestBody body, Param[] headers, AsyncHttpPaginatedResponse.Callback callback) {
        headers = HttpUtils.mergeHeaders(HttpUtils.defaultAcceptHeaders(false), headers);
        new AsyncHttpPaginatedQuery(http, method, path, headers, params, body).exec(callback);
    }

    @Experimental
    public PublishResponse[] publishBatch(Message.Batch[] pubSpecs, ChannelOptions channelOptions) throws AblyException {
        return this.publishBatchImpl(pubSpecs, channelOptions, null).sync();
    }

    @Experimental
    public PublishResponse[] publishBatch(Message.Batch[] pubSpecs, ChannelOptions channelOptions, Param[] params) throws AblyException {
        return this.publishBatchImpl(pubSpecs, channelOptions, params).sync();
    }

    @Experimental
    public void publishBatchAsync(Message.Batch[] pubSpecs, ChannelOptions channelOptions, Callback<PublishResponse[]> callback) throws AblyException {
        this.publishBatchImpl(pubSpecs, channelOptions, null).async(callback);
    }

    @Experimental
    public void publishBatchAsync(Message.Batch[] pubSpecs, ChannelOptions channelOptions, Param[] params, Callback<PublishResponse[]> callback) throws AblyException {
        this.publishBatchImpl(pubSpecs, channelOptions, params).async(callback);
    }

    private Http.Request<PublishResponse[]> publishBatchImpl(final Message.Batch[] pubSpecs, ChannelOptions channelOptions, final Param[] initialParams) throws AblyException {
        boolean hasClientSuppliedId = false;
        for (Message.Batch spec : pubSpecs) {
            for (Message message : spec.messages) {
                hasClientSuppliedId |= message.id != null;
                this.auth.checkClientId(message, true, false);
                message.encode(channelOptions);
            }
            if (hasClientSuppliedId || !this.options.idempotentRestPublishing) continue;
            String messageId = Crypto.getRandomId();
            for (int i = 0; i < spec.messages.length; ++i) {
                spec.messages[i].id = messageId + ':' + i;
            }
        }
        return this.http.request(new Http.Execute<PublishResponse[]>(){

            @Override
            public void execute(HttpScheduler http, Callback<PublishResponse[]> callback) throws AblyException {
                HttpCore.RequestBody requestBody = AblyBase.this.options.useBinaryProtocol ? MessageSerializer.asMsgpackRequest(pubSpecs) : MessageSerializer.asJSONRequest(pubSpecs);
                Param[] params = AblyBase.this.options.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
                Param[] headers = Param.set(HttpUtils.defaultAcceptHeaders(AblyBase.this.options.useBinaryProtocol), new Param("X-Ably-Version", 2));
                http.post("/messages", headers, params, requestBody, new HttpCore.ResponseHandler<PublishResponse[]>(){

                    @Override
                    public PublishResponse[] handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
                        if (error != null && error.code != 40020) {
                            throw AblyException.fromErrorInfo(error);
                        }
                        return PublishResponse.getBulkPublishResponseHandler(response.statusCode).handleResponseBody(response.contentType, response.body);
                    }
                }, true, callback);
            }
        });
    }

    protected void onAuthUpdated(String token, boolean waitForResponse) throws AblyException {
    }

    protected void onAuthUpdatedAsync(String token, Auth.AuthUpdateResult authUpdateResult) {
    }

    protected void onAuthError(ErrorInfo errorInfo) {
    }

    protected void onClientIdSet(String clientId) {
    }

    private class InternalChannels
    extends InternalMap<String, Channel>
    implements Channels {
        private InternalChannels() {
        }

        @Override
        public Channel get(String channelName) {
            try {
                return this.get(channelName, null);
            }
            catch (AblyException e) {
                return null;
            }
        }

        @Override
        public Channel get(String channelName, ChannelOptions channelOptions) throws AblyException {
            Channel channel = (Channel)this.map.get(channelName);
            if (channel != null) {
                if (channelOptions != null) {
                    channel.options = channelOptions;
                }
                return channel;
            }
            channel = new Channel(AblyBase.this, channelName, channelOptions);
            this.map.put(channelName, channel);
            return channel;
        }

        @Override
        public void release(String channelName) {
            this.map.remove(channelName);
        }
    }

    public static interface Channels
    extends ReadOnlyMap<String, Channel> {
        public Channel get(String var1);

        public Channel get(String var1, ChannelOptions var2) throws AblyException;

        public void release(String var1);

        @Override
        public int size();

        @Override
        public Iterable<Channel> values();
    }
}

