/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects;

import io.ably.lib.objects.ObjectsAdapter;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.ChannelBase;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.util.Log;
import org.jetbrains.annotations.NotNull;

public class Adapter
implements ObjectsAdapter {
    private final AblyRealtime ably;
    private static final String TAG = ObjectsAdapter.class.getName();

    public Adapter(@NotNull AblyRealtime ably) {
        this.ably = ably;
    }

    @Override
    @NotNull
    public ClientOptions getClientOptions() {
        return this.ably.options;
    }

    @Override
    @NotNull
    public ConnectionManager getConnectionManager() {
        return this.ably.connection.connectionManager;
    }

    @Override
    public long getTime() throws AblyException {
        return this.ably.time();
    }

    @Override
    @NotNull
    public ChannelBase getChannel(@NotNull String channelName) throws AblyException {
        if (this.ably.channels.containsKey(channelName)) {
            return this.ably.channels.get(channelName);
        }
        Log.e(TAG, "attachChannel(): channel not found: " + channelName);
        ErrorInfo errorInfo = new ErrorInfo("Channel not found: " + channelName, 404);
        throw AblyException.fromErrorInfo(errorInfo);
    }
}

