/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.objects.type.map;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.ably.lib.objects.type.counter.LiveCounter;
import io.ably.lib.objects.type.map.LiveMap;
import org.jetbrains.annotations.NotNull;

public abstract class LiveMapValue {
    @NotNull
    public abstract Object getValue();

    public boolean isBoolean() {
        return false;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isJsonArray() {
        return false;
    }

    public boolean isJsonObject() {
        return false;
    }

    public boolean isLiveCounter() {
        return false;
    }

    public boolean isLiveMap() {
        return false;
    }

    @NotNull
    public Boolean getAsBoolean() {
        throw new IllegalStateException("Not a Boolean value");
    }

    public byte @NotNull [] getAsBinary() {
        throw new IllegalStateException("Not a Binary value");
    }

    @NotNull
    public Number getAsNumber() {
        throw new IllegalStateException("Not a Number value");
    }

    @NotNull
    public String getAsString() {
        throw new IllegalStateException("Not a String value");
    }

    @NotNull
    public JsonArray getAsJsonArray() {
        throw new IllegalStateException("Not a JsonArray value");
    }

    @NotNull
    public JsonObject getAsJsonObject() {
        throw new IllegalStateException("Not a JsonObject value");
    }

    @NotNull
    public LiveCounter getAsLiveCounter() {
        throw new IllegalStateException("Not a LiveCounter value");
    }

    @NotNull
    public LiveMap getAsLiveMap() {
        throw new IllegalStateException("Not a LiveMap value");
    }

    @NotNull
    public static LiveMapValue of(@NotNull Boolean value) {
        return new BooleanValue(value);
    }

    @NotNull
    public static LiveMapValue of(byte @NotNull [] value) {
        return new BinaryValue(value);
    }

    @NotNull
    public static LiveMapValue of(@NotNull Number value) {
        return new NumberValue(value);
    }

    @NotNull
    public static LiveMapValue of(@NotNull String value) {
        return new StringValue(value);
    }

    @NotNull
    public static LiveMapValue of(@NotNull JsonArray value) {
        return new JsonArrayValue(value);
    }

    @NotNull
    public static LiveMapValue of(@NotNull JsonObject value) {
        return new JsonObjectValue(value);
    }

    @NotNull
    public static LiveMapValue of(@NotNull LiveCounter value) {
        return new LiveCounterValue(value);
    }

    @NotNull
    public static LiveMapValue of(@NotNull LiveMap value) {
        return new LiveMapValueWrapper(value);
    }

    private static final class BooleanValue
    extends LiveMapValue {
        private final Boolean value;

        BooleanValue(@NotNull Boolean value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        @Override
        @NotNull
        public Boolean getAsBoolean() {
            return this.value;
        }
    }

    private static final class BinaryValue
    extends LiveMapValue {
        private final byte[] value;

        BinaryValue(byte @NotNull [] value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public byte @NotNull [] getAsBinary() {
            return this.value;
        }
    }

    private static final class NumberValue
    extends LiveMapValue {
        private final Number value;

        NumberValue(@NotNull Number value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        @NotNull
        public Number getAsNumber() {
            return this.value;
        }
    }

    private static final class StringValue
    extends LiveMapValue {
        private final String value;

        StringValue(@NotNull String value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        @NotNull
        public String getAsString() {
            return this.value;
        }
    }

    private static final class JsonArrayValue
    extends LiveMapValue {
        private final JsonArray value;

        JsonArrayValue(@NotNull JsonArray value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isJsonArray() {
            return true;
        }

        @Override
        @NotNull
        public JsonArray getAsJsonArray() {
            return this.value;
        }
    }

    private static final class JsonObjectValue
    extends LiveMapValue {
        private final JsonObject value;

        JsonObjectValue(@NotNull JsonObject value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isJsonObject() {
            return true;
        }

        @Override
        @NotNull
        public JsonObject getAsJsonObject() {
            return this.value;
        }
    }

    private static final class LiveCounterValue
    extends LiveMapValue {
        private final LiveCounter value;

        LiveCounterValue(@NotNull LiveCounter value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isLiveCounter() {
            return true;
        }

        @Override
        @NotNull
        public LiveCounter getAsLiveCounter() {
            return this.value;
        }
    }

    private static final class LiveMapValueWrapper
    extends LiveMapValue {
        private final LiveMap value;

        LiveMapValueWrapper(@NotNull LiveMap value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isLiveMap() {
            return true;
        }

        @Override
        @NotNull
        public LiveMap getAsLiveMap() {
            return this.value;
        }
    }
}

