/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.Defaults;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import java.util.Arrays;
import java.util.Collections;

public class Hosts {
    private String primaryHost;
    private String prefHost;
    private long prefHostExpiry;
    boolean primaryHostIsDefault;
    private final String defaultHost;
    private final String[] fallbackHosts;
    private final boolean fallbackHostsIsDefault;
    private final boolean fallbackHostsUseDefault;
    private final long fallbackRetryTimeout;

    public Hosts(String primaryHost, String defaultHost, ClientOptions options) throws AblyException {
        boolean isProduction;
        this.defaultHost = defaultHost;
        this.fallbackHostsUseDefault = options.fallbackHostsUseDefault;
        boolean hasCustomPrimaryHost = primaryHost != null && !primaryHost.equalsIgnoreCase(defaultHost);
        Object[] tempFallbackHosts = options.fallbackHosts;
        if (options.fallbackHostsUseDefault) {
            if (options.fallbackHosts != null) {
                throw AblyException.fromErrorInfo(new ErrorInfo("fallbackHosts and fallbackHostsUseDefault cannot both be set", 40000, 400));
            }
            if (options.port != 0 || options.tlsPort != 0) {
                throw AblyException.fromErrorInfo(new ErrorInfo("fallbackHostsUseDefault cannot be set when port or tlsPort are set", 40000, 400));
            }
            tempFallbackHosts = Defaults.HOST_FALLBACKS;
        }
        boolean bl = isProduction = options.environment == null || options.environment.isEmpty() || "production".equalsIgnoreCase(options.environment);
        if (!hasCustomPrimaryHost && tempFallbackHosts == null && options.port == 0 && options.tlsPort == 0) {
            Object[] objectArray = tempFallbackHosts = isProduction ? Defaults.HOST_FALLBACKS : Defaults.getEnvironmentFallbackHosts(options.environment);
        }
        if (hasCustomPrimaryHost) {
            this.setPrimaryHost(primaryHost);
            if (options.environment != null) {
                throw AblyException.fromErrorInfo(new ErrorInfo("cannot set both restHost/realtimeHost and environment options", 40000, 400));
            }
        } else {
            this.setPrimaryHost(isProduction ? defaultHost : options.environment + "-" + defaultHost);
        }
        this.fallbackHostsIsDefault = Arrays.equals(Defaults.HOST_FALLBACKS, tempFallbackHosts);
        this.fallbackHosts = tempFallbackHosts == null ? new String[]{} : (String[])tempFallbackHosts.clone();
        Collections.shuffle(Arrays.asList(this.fallbackHosts));
        this.fallbackRetryTimeout = options.fallbackRetryTimeout;
    }

    private void setPrimaryHost(String primaryHost) {
        this.primaryHost = primaryHost;
        this.primaryHostIsDefault = primaryHost.equalsIgnoreCase(this.defaultHost);
    }

    public void setPreferredHost(String prefHost, boolean temporary) {
        if (prefHost.equals(this.prefHost)) {
            return;
        }
        if (prefHost.equals(this.primaryHost)) {
            this.clearPreferredHost();
        } else {
            this.prefHost = prefHost;
            this.prefHostExpiry = temporary ? System.currentTimeMillis() + this.fallbackRetryTimeout : 0L;
        }
    }

    private void clearPreferredHost() {
        this.prefHost = null;
        this.prefHostExpiry = 0L;
    }

    public String getPrimaryHost() {
        return this.primaryHost;
    }

    public String getPreferredHost() {
        this.checkPreferredHostExpiry();
        return this.prefHost == null ? this.primaryHost : this.prefHost;
    }

    private String checkPreferredHostExpiry() {
        if (this.prefHostExpiry > 0L && this.prefHostExpiry <= System.currentTimeMillis()) {
            this.prefHostExpiry = 0L;
            this.prefHost = null;
        }
        return this.prefHost;
    }

    public String getFallback(String lastHost) {
        int idx;
        if (this.fallbackHosts == null) {
            return null;
        }
        if (lastHost.equals(this.primaryHost)) {
            if (!this.primaryHostIsDefault && !this.fallbackHostsUseDefault && this.fallbackHostsIsDefault) {
                return null;
            }
            idx = 0;
        } else {
            if (lastHost.equals(this.checkPreferredHostExpiry())) {
                this.clearPreferredHost();
                return this.primaryHost;
            }
            idx = Arrays.asList(this.fallbackHosts).indexOf(lastHost);
            if (idx < 0) {
                return null;
            }
            ++idx;
        }
        if (idx >= this.fallbackHosts.length) {
            return null;
        }
        return this.fallbackHosts[idx];
    }

    public int fallbackHostsRemaining(String candidateHost) {
        if (this.fallbackHosts == null) {
            return 0;
        }
        if (candidateHost.equals(this.primaryHost) || candidateHost.equals(this.prefHost)) {
            return this.fallbackHosts.length;
        }
        return this.fallbackHosts.length - Arrays.asList(this.fallbackHosts).indexOf(candidateHost) - 1;
    }
}

