/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.util;

import java.io.PrintStream;

public class Log {
    public static final int NONE = 99;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int defaultLevel = 5;
    public static int level = 5;
    public static final LogHandler defaultHandler;
    public static LogHandler handler;
    private static String[] severities;

    public static int v(String tag, String msg) {
        Log.print(2, tag, msg, null);
        return 0;
    }

    public static int v(String tag, String msg, Throwable tr) {
        Log.print(2, tag, msg, tr);
        return 0;
    }

    public static int d(String tag, String msg) {
        Log.print(3, tag, msg, null);
        return 0;
    }

    public static int d(String tag, String msg, Throwable tr) {
        Log.print(3, tag, msg, tr);
        return 0;
    }

    public static int i(String tag, String msg) {
        Log.print(4, tag, msg, null);
        return 0;
    }

    public static int i(String tag, String msg, Throwable tr) {
        Log.print(4, tag, msg, tr);
        return 0;
    }

    public static int w(String tag, String msg) {
        Log.print(5, tag, msg, null);
        return 0;
    }

    public static int w(String tag, String msg, Throwable tr) {
        Log.print(5, tag, msg, tr);
        return 0;
    }

    public static int w(String tag, Throwable tr) {
        Log.print(5, tag, null, tr);
        return 0;
    }

    public static int e(String tag, String msg) {
        Log.print(6, tag, msg, null);
        return 0;
    }

    public static int e(String tag, String msg, Throwable tr) {
        Log.print(6, tag, msg, tr);
        return 0;
    }

    public static void setLevel(int level) {
        Log.level = level != 0 ? level : 5;
    }

    public static void setHandler(LogHandler handler) {
        Log.handler = handler != null ? handler : defaultHandler;
    }

    private static void print(int severity, String tag, String msg, Throwable tr) {
        if (severity >= level) {
            handler.println(severity, tag, msg, tr);
        }
    }

    static {
        handler = defaultHandler = new DefaultHandler();
        severities = new String[]{"", "", "VERBOSE", "DEBUG", "INFO", "WARN", "ERROR", "ASSERT"};
    }

    public static class DefaultHandler
    implements LogHandler {
        @Override
        public void println(int severity, String tag, String msg, Throwable tr) {
            this.println(System.out, severity, tag, msg, tr);
        }

        protected void println(PrintStream stream, int severity, String tag, String msg, Throwable tr) {
            stream.print("(" + severities[severity] + "): ");
            if (tag != null && tag.length() != 0) {
                stream.print(tag + ": ");
            }
            if (msg != null && msg.length() != 0) {
                stream.print(msg);
            }
            stream.println();
            if (tr != null) {
                tr.printStackTrace(stream);
            }
        }
    }

    public static interface LogHandler {
        public void println(int var1, String var2, String var3, Throwable var4);
    }
}

