/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.transport;

import io.ably.lib.transport.ITransport;
import io.ably.lib.transport.WebSocketTransport;
import io.ably.lib.types.ClientOptions;
import java.text.DecimalFormat;

public class Defaults {
    public static final float ABLY_VERSION_NUMBER = 1.0f;
    public static final String ABLY_VERSION = new DecimalFormat("0.0").format(1.0);
    public static final String ABLY_LIB_VERSION = String.format("%s-%s", "java", "1.1.9");
    public static final String ABLY_VERSION_PARAM = "v";
    public static final String ABLY_LIB_PARAM = "lib";
    public static final String ABLY_VERSION_HEADER = "X-Ably-Version";
    public static final String ABLY_LIB_HEADER = "X-Ably-Lib";
    public static final String[] HOST_FALLBACKS = new String[]{"A.ably-realtime.com", "B.ably-realtime.com", "C.ably-realtime.com", "D.ably-realtime.com", "E.ably-realtime.com"};
    public static final String HOST_REST = "rest.ably.io";
    public static final String HOST_REALTIME = "realtime.ably.io";
    public static final int PORT = 80;
    public static final int TLS_PORT = 443;
    public static int TIMEOUT_CONNECT = 15000;
    public static int TIMEOUT_DISCONNECT = 15000;
    public static int TIMEOUT_CHANNEL_RETRY = 15000;
    public static int TIMEOUT_HTTP_OPEN = 4000;
    public static int TIMEOUT_HTTP_REQUEST = 15000;
    public static long realtimeRequestTimeout = 10000L;
    public static long fallbackRetryTimeout = 600000L;
    public static long maxIdleInterval = 20000L;
    public static long connectionStateTtl = 60000L;
    public static final ITransport.Factory TRANSPORT = new WebSocketTransport.Factory();
    public static final int HTTP_MAX_RETRY_COUNT = 3;
    public static final int HTTP_ASYNC_THREADPOOL_SIZE = 64;

    public static int getPort(ClientOptions options) {
        return options.tls ? (options.tlsPort != 0 ? options.tlsPort : 443) : (options.port != 0 ? options.port : 80);
    }
}

