/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpHelpers;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.rest.AblyBase;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.BaseMessage;
import io.ably.lib.types.Capability;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Auth {
    public String clientId;
    private static final String TAG = Auth.class.getName();
    private final AblyBase ably;
    private final AuthMethod method;
    private AuthOptions authOptions;
    private TokenParams tokenParams;
    private String basicCredentials;
    private TokenDetails tokenDetails;
    private String encodedToken;
    private String authHeader;
    private long timeDelta = Long.MAX_VALUE;
    private long nanoTimeDelta = System.currentTimeMillis() - System.nanoTime() / 1000000L;
    public static final String WILDCARD_CLIENTID = "*";

    public TokenDetails authorize(TokenParams params, AuthOptions options) throws AblyException {
        TokenDetails tokenDetails;
        if (options != null) {
            this.authOptions = options.storedValues();
        }
        if (params != null) {
            this.tokenParams = params.storedValues();
        }
        options = options == null ? this.authOptions : options.copy();
        TokenParams tokenParams = params = params == null ? this.tokenParams : params.copy();
        if (this.authOptions.token != null) {
            this.authOptions.tokenDetails = new TokenDetails(this.authOptions.token);
        }
        if (this.authOptions.tokenDetails != null) {
            tokenDetails = this.authOptions.tokenDetails;
            this.setTokenDetails(tokenDetails);
        } else {
            try {
                tokenDetails = this.assertValidToken(params, options, true);
            }
            catch (AblyException e) {
                this.ably.onAuthError(e.errorInfo);
                throw e;
            }
        }
        this.ably.onAuthUpdated(tokenDetails.token, true);
        return tokenDetails;
    }

    @Deprecated
    public TokenDetails authorise(TokenParams params, AuthOptions options) throws AblyException {
        Log.w(TAG, "authorise() is deprecated and will be removed in 1.0. Please use authorize() instead");
        return this.authorize(params, options);
    }

    public TokenDetails requestToken(TokenParams params, AuthOptions tokenOptions) throws AblyException {
        TokenRequest signedTokenRequest;
        tokenOptions = tokenOptions == null ? this.authOptions : tokenOptions.copy();
        TokenParams tokenParams = params = params == null ? this.tokenParams : params.copy();
        if (params.clientId == null) {
            params.clientId = this.ably.clientId;
        }
        params.capability = Capability.c14n(params.capability);
        if (tokenOptions.authCallback != null) {
            Log.i("Auth.requestToken()", "using token auth with auth_callback");
            try {
                Object authCallbackResponse = tokenOptions.authCallback.getTokenRequest(params);
                if (authCallbackResponse instanceof String) {
                    return new TokenDetails((String)authCallbackResponse);
                }
                if (authCallbackResponse instanceof TokenDetails) {
                    return (TokenDetails)authCallbackResponse;
                }
                if (!(authCallbackResponse instanceof TokenRequest)) {
                    throw AblyException.fromErrorInfo(new ErrorInfo("Invalid authCallback response", 400, 40000));
                }
                signedTokenRequest = (TokenRequest)authCallbackResponse;
            }
            catch (AblyException e) {
                throw AblyException.fromErrorInfo(e, new ErrorInfo("authCallback failed with an exception", 401, 80019));
            }
        }
        if (tokenOptions.authUrl != null) {
            Log.i("Auth.requestToken()", "using token auth with auth_url");
            Object authUrlResponse = null;
            try {
                HttpCore.ResponseHandler<Object> responseHandler = new HttpCore.ResponseHandler<Object>(){

                    @Override
                    public Object handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
                        if (error != null) {
                            throw AblyException.fromErrorInfo(error);
                        }
                        try {
                            JsonElement json;
                            String contentType = response.contentType;
                            byte[] body = response.body;
                            if (body == null || body.length == 0) {
                                return null;
                            }
                            if (contentType != null) {
                                if (contentType.startsWith("text/plain") || contentType.startsWith("application/jwt")) {
                                    String token = new String(body);
                                    return new TokenDetails(token);
                                }
                                if (!contentType.startsWith("application/json")) {
                                    throw AblyException.fromErrorInfo(new ErrorInfo("Unacceptable content type from auth callback", 406, 40170));
                                }
                            }
                            if (!((json = Serialisation.gsonParser.parse(new String(body))) instanceof JsonObject)) {
                                throw AblyException.fromErrorInfo(new ErrorInfo("Unexpected response type from auth callback", 406, 40170));
                            }
                            JsonObject jsonObject = (JsonObject)json;
                            if (jsonObject.has("issued")) {
                                return TokenDetails.fromJsonElement(jsonObject);
                            }
                            return TokenRequest.fromJsonElement(jsonObject);
                        }
                        catch (JsonParseException e) {
                            throw AblyException.fromErrorInfo(new ErrorInfo("Unable to parse response from auth callback", 406, 40170));
                        }
                    }
                };
                Map<String, Param> urlParams = null;
                URL authUrl = HttpUtils.parseUrl(this.authOptions.authUrl);
                String queryString = authUrl.getQuery();
                if (queryString != null && !queryString.isEmpty()) {
                    urlParams = HttpUtils.decodeParams(queryString);
                }
                Map<String, Param> tokenParams2 = params.asMap();
                if (tokenOptions.authParams != null) {
                    for (Param p : tokenOptions.authParams) {
                        if (tokenParams2.containsKey(p.key)) continue;
                        tokenParams2.put(p.key, p);
                    }
                }
                if ("POST".equals(tokenOptions.authMethod)) {
                    authUrlResponse = HttpHelpers.postUri(this.ably.httpCore, tokenOptions.authUrl, tokenOptions.authHeaders, HttpUtils.flattenParams(urlParams), HttpUtils.flattenParams(tokenParams2), responseHandler);
                } else {
                    Map<String, Param> requestParams = urlParams != null ? HttpUtils.mergeParams(urlParams, tokenParams2) : tokenParams2;
                    authUrlResponse = HttpHelpers.getUri(this.ably.httpCore, tokenOptions.authUrl, tokenOptions.authHeaders, HttpUtils.flattenParams(requestParams), responseHandler);
                }
            }
            catch (AblyException e) {
                throw AblyException.fromErrorInfo(e, new ErrorInfo("authUrl failed with an exception", 401, 80019));
            }
            if (authUrlResponse == null) {
                throw AblyException.fromErrorInfo(null, new ErrorInfo("Empty response received from authUrl", 401, 80019));
            }
            if (authUrlResponse instanceof TokenDetails) {
                return (TokenDetails)authUrlResponse;
            }
            signedTokenRequest = (TokenRequest)authUrlResponse;
        } else if (tokenOptions.key != null) {
            Log.i("Auth.requestToken()", "using token auth with client-side signing");
            signedTokenRequest = this.createTokenRequest(params, tokenOptions);
        } else {
            throw AblyException.fromErrorInfo(new ErrorInfo("Auth.requestToken(): options must include valid authentication parameters", 400, 40106));
        }
        String tokenPath = "/keys/" + signedTokenRequest.keyName + "/requestToken";
        return HttpHelpers.postSync(this.ably.http, tokenPath, null, null, new HttpUtils.JsonRequestBody(signedTokenRequest.asJsonElement().toString()), new HttpCore.ResponseHandler<TokenDetails>(){

            @Override
            public TokenDetails handleResponse(HttpCore.Response response, ErrorInfo error) throws AblyException {
                if (error != null) {
                    throw AblyException.fromErrorInfo(error);
                }
                try {
                    String jsonText = new String(response.body);
                    JsonObject json = (JsonObject)Serialisation.gsonParser.parse(jsonText);
                    return TokenDetails.fromJsonElement(json);
                }
                catch (JsonParseException e) {
                    throw AblyException.fromThrowable(e);
                }
            }
        }, false);
    }

    public TokenRequest createTokenRequest(TokenParams params, AuthOptions options) throws AblyException {
        String clientIdText;
        String capabilityText;
        options = options == null ? this.authOptions : options.copy();
        TokenParams tokenParams = params = params == null ? this.tokenParams : params.copy();
        if (params.capability != null) {
            params.capability = Capability.c14n(params.capability);
        }
        TokenRequest request = new TokenRequest(params);
        String key = options.key;
        if (key == null) {
            throw AblyException.fromErrorInfo(new ErrorInfo("No key specified", 401, 40101));
        }
        String[] keyParts = key.split(":");
        if (keyParts.length != 2) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Invalid key specified", 401, 40101));
        }
        String keyName = keyParts[0];
        String keySecret = keyParts[1];
        if (request.keyName == null) {
            request.keyName = keyName;
        } else if (!request.keyName.equals(keyName)) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Incompatible keys specified", 401, 40102));
        }
        String ttlText = request.ttl == 0L ? "" : String.valueOf(request.ttl);
        String string = capabilityText = request.capability == null ? "" : request.capability;
        if (request.clientId == null) {
            request.clientId = this.ably.clientId;
        }
        String string2 = clientIdText = request.clientId == null ? "" : request.clientId;
        if (request.timestamp == 0L) {
            if (options.queryTime) {
                long oldNanoTimeDelta = this.nanoTimeDelta;
                long currentNanoTimeDelta = System.currentTimeMillis() - System.nanoTime() / 1000000L;
                if (this.timeDelta != Long.MAX_VALUE && Math.abs(oldNanoTimeDelta - currentNanoTimeDelta) > 500L) {
                    this.timeDelta = Long.MAX_VALUE;
                }
                if (this.timeDelta != Long.MAX_VALUE) {
                    request.timestamp = Auth.timestamp() + this.timeDelta;
                    this.nanoTimeDelta = currentNanoTimeDelta;
                } else {
                    request.timestamp = this.ably.time();
                    this.timeDelta = request.timestamp - Auth.timestamp();
                }
            } else {
                request.timestamp = Auth.timestamp();
            }
        }
        request.nonce = Auth.random();
        String signText = request.keyName + '\n' + ttlText + '\n' + capabilityText + '\n' + clientIdText + '\n' + request.timestamp + '\n' + request.nonce + '\n';
        request.mac = Auth.hmac(signText, keySecret);
        Log.i("Auth.getTokenRequest()", "generated signed request");
        return request;
    }

    public AuthMethod getAuthMethod() {
        return this.method;
    }

    public String getBasicCredentials() {
        return this.method == AuthMethod.basic ? this.basicCredentials : null;
    }

    public Param[] getAuthParams() throws AblyException {
        Param[] params = null;
        switch (this.method) {
            case basic: {
                params = new Param[]{new Param("key", this.authOptions.key)};
                break;
            }
            case token: {
                this.assertValidToken();
                params = new Param[]{new Param("accessToken", this.getTokenDetails().token)};
            }
        }
        return params;
    }

    public AuthOptions getAuthOptions() {
        return this.authOptions.copy();
    }

    public TokenDetails renew() throws AblyException {
        TokenDetails tokenDetails = this.assertValidToken(this.tokenParams, this.authOptions, true);
        this.ably.onAuthUpdated(tokenDetails.token, false);
        return tokenDetails;
    }

    public void onAuthError(ErrorInfo err) {
        if (err.code >= 40140 && err.code < 40150) {
            this.clearTokenDetails();
        }
    }

    public static long timestamp() {
        return System.currentTimeMillis();
    }

    Auth(AblyBase ably, ClientOptions options) throws AblyException {
        this.ably = ably;
        this.authOptions = options;
        TokenParams tokenParams = this.tokenParams = options.defaultTokenParams != null ? options.defaultTokenParams : new TokenParams();
        if (options.clientId != null) {
            if (options.clientId.equals(WILDCARD_CLIENTID)) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Disallowed wildcard clientId in ClientOptions", 400, 40000));
            }
            this.setClientId(options.clientId);
            this.tokenParams.clientId = options.clientId;
        }
        if (this.authOptions.key != null && options.clientId == null && !options.useTokenAuth && options.token == null && options.tokenDetails == null && options.authCallback == null && options.authUrl == null) {
            Log.i("Auth()", "anonymous, using basic auth");
            this.method = AuthMethod.basic;
            this.basicCredentials = this.authOptions.key;
            this.setClientId(WILDCARD_CLIENTID);
            return;
        }
        this.method = AuthMethod.token;
        if (this.authOptions.token != null) {
            this.setTokenDetails(this.authOptions.token);
        } else if (this.authOptions.tokenDetails != null) {
            this.setTokenDetails(this.authOptions.tokenDetails);
        }
        if (this.authOptions.authCallback != null) {
            Log.i("Auth()", "using token auth with authCallback");
        } else if (this.authOptions.authUrl != null) {
            HttpUtils.parseUrl(this.authOptions.authUrl);
            Log.i("Auth()", "using token auth with authUrl");
        } else if (this.authOptions.key != null) {
            Log.i("Auth()", "using token auth with client-side signing");
        } else if (this.tokenDetails != null) {
            Log.i("Auth()", "using token auth with supplied token only");
        } else {
            Log.e("Auth()", "no authentication parameters supplied");
            throw AblyException.fromErrorInfo(new ErrorInfo("No authentication parameters supplied", 400, 40000));
        }
    }

    public TokenDetails getTokenDetails() {
        Log.i("TokenAuth.getTokenDetails()", "");
        return this.tokenDetails;
    }

    public String getEncodedToken() {
        Log.i("TokenAuth.getEncodedToken()", "");
        return this.encodedToken;
    }

    private void setTokenDetails(String token) throws AblyException {
        Log.i("TokenAuth.setTokenDetails()", "");
        this.tokenDetails = new TokenDetails(token);
        this.encodedToken = Base64Coder.encodeString(token).replace("=", "");
    }

    private void setTokenDetails(TokenDetails tokenDetails) throws AblyException {
        Log.i("TokenAuth.setTokenDetails()", "");
        this.setClientId(tokenDetails.clientId);
        this.tokenDetails = tokenDetails;
        this.encodedToken = Base64Coder.encodeString(tokenDetails.token).replace("=", "");
    }

    private void clearTokenDetails() {
        Log.i("TokenAuth.clearTokenDetails()", "");
        this.tokenDetails = null;
        this.encodedToken = null;
        this.authHeader = null;
    }

    public TokenDetails assertValidToken() throws AblyException {
        return this.assertValidToken(this.tokenParams, this.authOptions, false);
    }

    private TokenDetails assertValidToken(TokenParams params, AuthOptions options, boolean force) throws AblyException {
        Log.i("Auth.assertValidToken()", "");
        if (this.tokenDetails != null) {
            if (!force && (this.tokenDetails.expires == 0L || this.tokenValid(this.tokenDetails))) {
                Log.i("Auth.assertValidToken()", "using cached token; expires = " + this.tokenDetails.expires);
                return this.tokenDetails;
            }
            Log.i("Auth.assertValidToken()", "deleting expired token");
            this.clearTokenDetails();
        }
        Log.i("Auth.assertValidToken()", "requesting new token");
        this.setTokenDetails(this.requestToken(params, options));
        return this.tokenDetails;
    }

    private boolean tokenValid(TokenDetails tokenDetails) {
        return this.timeDelta == Long.MAX_VALUE || tokenDetails.expires > this.serverTimestamp();
    }

    public void assertAuthorizationHeader(boolean forceRenew) throws AblyException {
        if (this.authHeader != null && !forceRenew) {
            return;
        }
        if (this.getAuthMethod() == AuthMethod.basic) {
            this.authHeader = "Basic " + Base64Coder.encodeString(this.getBasicCredentials());
        } else {
            if (forceRenew) {
                this.renew();
            } else {
                this.assertValidToken();
            }
            this.authHeader = "Bearer " + this.getEncodedToken();
        }
    }

    public String getAuthorizationHeader() {
        return this.authHeader;
    }

    private static String random() {
        return String.format("%016d", (long)(Math.random() * 1.0E16));
    }

    private static boolean equalNullableStrings(String one, String two) {
        return one == null ? two == null : one.equals(two);
    }

    private static final String hmac(String text, String key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key.getBytes(Charset.forName("UTF-8")), "HmacSHA256"));
            return new String(Base64Coder.encode(mac.doFinal(text.getBytes(Charset.forName("UTF-8")))));
        }
        catch (GeneralSecurityException e) {
            Log.e("Auth.hmac", "Unexpected exception", e);
            return null;
        }
    }

    public void setClientId(String clientId) throws AblyException {
        if (this.clientId == null) {
            this.clientId = clientId;
            this.ably.onClientIdSet(clientId);
            return;
        }
        if (this.clientId.equals(clientId)) {
            return;
        }
        if (WILDCARD_CLIENTID.equals(clientId)) {
            return;
        }
        throw AblyException.fromErrorInfo(new ErrorInfo("Unable to set different clientId from that given in options", 401, 40101));
    }

    public String checkClientId(BaseMessage msg, boolean allowNullClientId, boolean connected) throws AblyException {
        boolean undeterminedClientId;
        String msgClientId = msg.clientId;
        if (WILDCARD_CLIENTID.equals(msgClientId)) {
            throw AblyException.fromErrorInfo(new ErrorInfo("Invalid wildcard clientId specified in message", 400, 40000));
        }
        boolean bl = undeterminedClientId = this.clientId == null && !connected;
        if (msgClientId != null) {
            if (msgClientId.equals(this.clientId) || WILDCARD_CLIENTID.equals(this.clientId) || undeterminedClientId) {
                return msgClientId;
            }
            throw AblyException.fromErrorInfo(new ErrorInfo("Incompatible clientId specified in message", 400, 40012));
        }
        if (this.clientId == null || this.clientId.equals(WILDCARD_CLIENTID)) {
            if (allowNullClientId || undeterminedClientId) {
                return null;
            }
            throw AblyException.fromErrorInfo(new ErrorInfo("Invalid attempt to enter with no clientId", 400, 91000));
        }
        return this.clientId;
    }

    public long serverTimestamp() {
        long clientTime = Auth.timestamp();
        long delta = this.timeDelta;
        return delta != Long.MAX_VALUE ? clientTime + this.timeDelta : clientTime;
    }

    public void clearCachedServerTime() {
        this.timeDelta = Long.MAX_VALUE;
    }

    public static interface TokenCallback {
        public Object getTokenRequest(TokenParams var1) throws AblyException;
    }

    public static class TokenRequest
    extends TokenParams {
        public String keyName;
        public String nonce;
        public String mac;

        public TokenRequest() {
        }

        public TokenRequest(TokenParams params) {
            this.ttl = params.ttl;
            this.capability = params.capability;
            this.clientId = params.clientId;
            this.timestamp = params.timestamp;
        }

        @Deprecated
        public static TokenRequest fromJSON(JsonObject json) {
            return (TokenRequest)Serialisation.gson.fromJson((JsonElement)json, TokenRequest.class);
        }

        public static TokenRequest fromJsonElement(JsonObject json) {
            return (TokenRequest)Serialisation.gson.fromJson((JsonElement)json, TokenRequest.class);
        }

        public static TokenRequest fromJson(String json) {
            return (TokenRequest)Serialisation.gson.fromJson(json, TokenRequest.class);
        }

        public JsonObject asJsonElement() {
            JsonObject o = (JsonObject)Serialisation.gson.toJsonTree((Object)this);
            if (this.ttl == 0L) {
                o.remove("ttl");
            }
            if (this.capability != null && this.capability.isEmpty()) {
                o.remove("capability");
            }
            return o;
        }

        public String asJson() {
            return this.asJsonElement().toString();
        }

        @Override
        public boolean equals(Object obj) {
            TokenRequest request = (TokenRequest)obj;
            return super.equals(obj) & Auth.equalNullableStrings(this.keyName, request.keyName) & Auth.equalNullableStrings(this.nonce, request.nonce) & Auth.equalNullableStrings(this.mac, request.mac);
        }
    }

    public static class TokenParams {
        public long ttl;
        public String capability;
        public String clientId;
        public long timestamp;

        public Map<String, Param> asMap() {
            HashMap<String, Param> params = new HashMap<String, Param>();
            if (this.ttl > 0L) {
                params.put("ttl", new Param("ttl", String.valueOf(this.ttl)));
            }
            if (this.capability != null) {
                params.put("capability", new Param("capability", this.capability));
            }
            if (this.clientId != null) {
                params.put("clientId", new Param("clientId", this.clientId));
            }
            if (this.timestamp > 0L) {
                params.put("timestamp", new Param("timestamp", String.valueOf(this.timestamp)));
            }
            return params;
        }

        public boolean equals(Object obj) {
            TokenParams params = (TokenParams)obj;
            return this.ttl == params.ttl & Auth.equalNullableStrings(this.capability, params.capability) & Auth.equalNullableStrings(this.clientId, params.clientId) & this.timestamp == params.timestamp;
        }

        private TokenParams storedValues() {
            TokenParams result = new TokenParams();
            result.ttl = this.ttl;
            result.capability = this.capability;
            result.clientId = this.clientId;
            return result;
        }

        private TokenParams copy() {
            TokenParams result = new TokenParams();
            result.ttl = this.ttl;
            result.capability = this.capability;
            result.clientId = this.clientId;
            result.timestamp = this.timestamp;
            return result;
        }
    }

    public static class TokenDetails {
        public String token;
        public long expires;
        public long issued;
        public String capability;
        public String clientId;

        public TokenDetails() {
        }

        public TokenDetails(String token) {
            this.token = token;
        }

        @Deprecated
        public static TokenDetails fromJSON(JsonObject json) {
            return (TokenDetails)Serialisation.gson.fromJson((JsonElement)json, TokenDetails.class);
        }

        public static TokenDetails fromJson(String json) {
            return (TokenDetails)Serialisation.gson.fromJson(json, TokenDetails.class);
        }

        public static TokenDetails fromJsonElement(JsonObject json) {
            return (TokenDetails)Serialisation.gson.fromJson((JsonElement)json, TokenDetails.class);
        }

        public JsonObject asJsonElement() {
            return (JsonObject)Serialisation.gson.toJsonTree((Object)this);
        }

        public String asJson() {
            return this.asJsonElement().toString();
        }

        public boolean equals(Object obj) {
            TokenDetails details = (TokenDetails)obj;
            return Auth.equalNullableStrings(this.token, details.token) & Auth.equalNullableStrings(this.capability, details.capability) & Auth.equalNullableStrings(this.clientId, details.clientId) & this.issued == details.issued & this.expires == details.expires;
        }
    }

    public static class AuthOptions {
        public TokenCallback authCallback;
        public String authUrl;
        public String authMethod;
        public String key;
        public String token;
        public TokenDetails tokenDetails;
        public Param[] authHeaders;
        public Param[] authParams;
        public boolean queryTime;
        public boolean useTokenAuth;

        public AuthOptions() {
        }

        public AuthOptions(String key) throws AblyException {
            if (key == null) {
                throw AblyException.fromErrorInfo(new ErrorInfo("key string cannot be null", 40000, 400));
            }
            if (key.indexOf(58) > -1) {
                this.key = key;
            } else {
                this.token = key;
            }
        }

        private AuthOptions storedValues() {
            AuthOptions result = new AuthOptions();
            result.key = this.key;
            result.authUrl = this.authUrl;
            result.authMethod = this.authMethod;
            result.authParams = this.authParams;
            result.authHeaders = this.authHeaders;
            result.token = this.token;
            result.tokenDetails = this.tokenDetails;
            result.authCallback = this.authCallback;
            return result;
        }

        private AuthOptions copy() {
            AuthOptions result = new AuthOptions();
            result.key = this.key;
            result.authUrl = this.authUrl;
            result.authMethod = this.authMethod;
            result.authParams = this.authParams;
            result.authHeaders = this.authHeaders;
            result.token = this.token;
            result.tokenDetails = this.tokenDetails;
            result.authCallback = this.authCallback;
            result.queryTime = this.queryTime;
            return result;
        }
    }

    public static enum AuthMethod {
        basic,
        token;

    }
}

