/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Crypto;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class BaseMessage
implements Cloneable {
    public String id;
    public long timestamp;
    public String clientId;
    public String connectionId;
    public String encoding;
    public Object data;
    private static Pattern xformPattern = Pattern.compile("([\\-\\w]+)(\\+([\\-\\w]+))?");
    private static final String TAG = BaseMessage.class.getName();

    public void getDetails(StringBuilder builder) {
        if (this.clientId != null) {
            builder.append(" clientId=").append(this.clientId);
        }
        if (this.connectionId != null) {
            builder.append(" connectionId=").append(this.connectionId);
        }
        if (this.data != null) {
            builder.append(" data=").append(this.data);
        }
        if (this.encoding != null) {
            builder.append(" encoding=").append(this.encoding);
        }
        if (this.id != null) {
            builder.append(" id=").append(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelOptions opts) throws MessageDecodeException {
        if (this.encoding != null) {
            String[] xforms = this.encoding.split("\\/");
            int i = 0;
            int j = xforms.length;
            try {
                Matcher match;
                block22: while ((i = j--) > 0 && (match = xformPattern.matcher(xforms[j])).matches()) {
                    switch (match.group(1)) {
                        case "base64": {
                            try {
                                this.data = Base64Coder.decode((String)this.data);
                                continue block22;
                            }
                            catch (IllegalArgumentException e) {
                                throw MessageDecodeException.fromDescription("Invalid base64 data received");
                            }
                        }
                        case "utf-8": {
                            try {
                                this.data = new String((byte[])this.data, "UTF-8");
                            }
                            catch (UnsupportedEncodingException | ClassCastException e) {}
                            continue block22;
                        }
                        case "json": {
                            try {
                                String jsonText = ((String)this.data).trim();
                                this.data = Serialisation.gsonParser.parse(jsonText);
                                continue block22;
                            }
                            catch (JsonParseException e) {
                                throw MessageDecodeException.fromDescription("Invalid JSON data received");
                            }
                        }
                        case "cipher": {
                            if (opts != null && opts.encrypted) {
                                try {
                                    this.data = opts.getCipher().decrypt((byte[])this.data);
                                    continue block22;
                                }
                                catch (AblyException e) {
                                    throw MessageDecodeException.fromDescription(e.errorInfo.message);
                                }
                            }
                            throw MessageDecodeException.fromDescription("Encrypted message received but encryption is not set up");
                        }
                    }
                }
                this.encoding = i <= 0 ? null : this.join(xforms, '/', 0, i);
            }
            catch (Throwable throwable) {
                this.encoding = i <= 0 ? null : this.join(xforms, '/', 0, i);
                throw throwable;
            }
        }
    }

    public void encode(ChannelOptions opts) throws AblyException {
        if (this.data != null) {
            if (this.data instanceof JsonElement) {
                this.data = Serialisation.gson.toJson((JsonElement)this.data);
                this.encoding = (this.encoding == null ? "" : this.encoding + "/") + "json";
            }
            if (this.data instanceof String) {
                if (opts != null && opts.encrypted) {
                    try {
                        this.data = ((String)this.data).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.encoding = (this.encoding == null ? "" : this.encoding + "/") + "utf-8";
                }
            } else if (!(this.data instanceof byte[])) {
                Log.d(TAG, "Message data must be either `byte[]`, `String` or `JSONElement`; implicit coercion of other types to String is deprecated");
                throw AblyException.fromErrorInfo(new ErrorInfo("Invalid message data or encoding", 400, 40013));
            }
        }
        if (opts != null && opts.encrypted) {
            Crypto.ChannelCipher cipher = opts.getCipher();
            this.data = cipher.encrypt((byte[])this.data);
            this.encoding = (this.encoding == null ? "" : this.encoding + "/") + "cipher+" + cipher.getAlgorithm();
        }
    }

    private String join(String[] elements, char separator, int start, int end) {
        StringBuilder result = new StringBuilder(elements[start++]);
        for (int i = start; i < end; ++i) {
            result.append(separator).append(elements[i]);
        }
        return result.toString();
    }

    boolean readField(MessageUnpacker unpacker, String fieldName, MessageFormat fieldType) throws IOException {
        boolean result = true;
        switch (fieldName) {
            case "timestamp": {
                this.timestamp = unpacker.unpackLong();
                break;
            }
            case "id": {
                this.id = unpacker.unpackString();
                break;
            }
            case "clientId": {
                this.clientId = unpacker.unpackString();
                break;
            }
            case "connectionId": {
                this.connectionId = unpacker.unpackString();
                break;
            }
            case "encoding": {
                this.encoding = unpacker.unpackString();
                break;
            }
            case "data": {
                if (fieldType.getValueType().isBinaryType()) {
                    byte[] byteData = new byte[unpacker.unpackBinaryHeader()];
                    unpacker.readPayload(byteData);
                    this.data = byteData;
                    break;
                }
                this.data = unpacker.unpackString();
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected int countFields() {
        int fieldCount = 0;
        if (this.timestamp > 0L) {
            ++fieldCount;
        }
        if (this.id != null) {
            ++fieldCount;
        }
        if (this.clientId != null) {
            ++fieldCount;
        }
        if (this.connectionId != null) {
            ++fieldCount;
        }
        if (this.encoding != null) {
            ++fieldCount;
        }
        if (this.data != null) {
            ++fieldCount;
        }
        return fieldCount;
    }

    void writeFields(MessagePacker packer) throws IOException {
        if (this.timestamp > 0L) {
            packer.packString("timestamp");
            packer.packLong(this.timestamp);
        }
        if (this.id != null) {
            packer.packString("id");
            packer.packString(this.id);
        }
        if (this.clientId != null) {
            packer.packString("clientId");
            packer.packString(this.clientId);
        }
        if (this.connectionId != null) {
            packer.packString("connectionId");
            packer.packString(this.connectionId);
        }
        if (this.encoding != null) {
            packer.packString("encoding");
            packer.packString(this.encoding);
        }
        if (this.data != null) {
            packer.packString("data");
            if (this.data instanceof byte[]) {
                byte[] byteData = (byte[])this.data;
                packer.packBinaryHeader(byteData.length);
                packer.writePayload(byteData);
            } else {
                packer.packString(this.data.toString());
            }
        }
    }

    public static class Serializer {
        public JsonElement serialize(BaseMessage message, Type typeOfMessage, JsonSerializationContext ctx) {
            JsonObject json = new JsonObject();
            Object data = message.data;
            String encoding = message.encoding;
            if (data != null) {
                if (data instanceof byte[]) {
                    byte[] dataBytes = (byte[])data;
                    json.addProperty("data", new String(Base64Coder.encode(dataBytes)));
                    encoding = encoding == null ? "base64" : encoding + "/base64";
                } else {
                    json.addProperty("data", data.toString());
                }
                if (encoding != null) {
                    json.addProperty("encoding", encoding);
                }
            }
            if (message.id != null) {
                json.addProperty("id", message.id);
            }
            if (message.clientId != null) {
                json.addProperty("clientId", message.clientId);
            }
            if (message.connectionId != null) {
                json.addProperty("connectionId", message.connectionId);
            }
            return json;
        }
    }
}

