/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import io.ably.lib.types.ErrorInfo;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class AblyException
extends Exception {
    private static final long serialVersionUID = -3804072091596832634L;
    public ErrorInfo errorInfo;

    protected AblyException(Throwable throwable, ErrorInfo reason) {
        super(throwable);
        this.errorInfo = reason;
    }

    public static AblyException fromErrorInfo(ErrorInfo errorInfo) {
        return AblyException.fromErrorInfo(new Exception(errorInfo.message), errorInfo);
    }

    public static AblyException fromErrorInfo(Throwable t, ErrorInfo errorInfo) {
        if (errorInfo.statusCode >= 500 && errorInfo.statusCode <= 504) {
            return new HostFailedException(t, errorInfo);
        }
        return new AblyException(t, errorInfo);
    }

    public static AblyException fromThrowable(Throwable t) {
        if (t instanceof AblyException) {
            return (AblyException)t;
        }
        if (t instanceof ConnectException || t instanceof SocketTimeoutException || t instanceof UnknownHostException || t instanceof NoRouteToHostException) {
            return new HostFailedException(t, ErrorInfo.fromThrowable(t));
        }
        return new AblyException(t, ErrorInfo.fromThrowable(t));
    }

    public static class HostFailedException
    extends AblyException {
        private static final long serialVersionUID = 1L;

        HostFailedException(Throwable throwable, ErrorInfo reason) {
            super(throwable, reason);
        }
    }
}

