/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.BaseMessage;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageExtras;
import io.ably.lib.types.MessageOperation;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.msgpack.core.MessagePacker;

public class MessageOperationSerializer {
    private static final String TAG = MessageOperationSerializer.class.getName();

    public static HttpCore.RequestBody asJsonRequest(Message message, MessageOperation operation, ChannelOptions channelOptions) throws AblyException {
        UpdateDeleteRequest request = new UpdateDeleteRequest(message, operation, channelOptions);
        return new HttpUtils.JsonRequestBody(Serialisation.gson.toJson((JsonElement)request.asJsonObject()));
    }

    public static HttpCore.RequestBody asMsgPackRequest(Message message, MessageOperation operation, ChannelOptions channelOptions) throws AblyException {
        UpdateDeleteRequest request = new UpdateDeleteRequest(message, operation, channelOptions);
        byte[] packed = MessageOperationSerializer.writeMsgpack(request);
        return new HttpUtils.ByteArrayRequestBody(packed, "application/x-msgpack");
    }

    private static byte[] writeMsgpack(UpdateDeleteRequest request) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePacker packer = Serialisation.msgpackPackerConfig.newPacker((OutputStream)out);
            request.writeMsgpack(packer);
            packer.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to write msgpack", e);
            return null;
        }
    }

    static class UpdateDeleteRequest {
        private static final String NAME = "name";
        private static final String DATA = "data";
        private static final String ENCODING = "encoding";
        private static final String EXTRAS = "extras";
        private static final String OPERATION = "operation";
        public final String name;
        public final Object data;
        public final String encoding;
        public final MessageExtras extras;
        public final MessageOperation operation;

        UpdateDeleteRequest(Message message, MessageOperation operation, ChannelOptions channelOptions) throws AblyException {
            this.operation = operation;
            this.name = message.name;
            this.extras = message.extras;
            BaseMessage.EncodedMessageData encodedMessageData = message.encodeData(channelOptions);
            this.data = encodedMessageData.data;
            this.encoding = encodedMessageData.encoding;
        }

        void writeMsgpack(MessagePacker packer) throws IOException {
            int fieldCount = 0;
            if (this.name != null) {
                ++fieldCount;
            }
            if (this.data != null) {
                ++fieldCount;
            }
            if (this.encoding != null) {
                ++fieldCount;
            }
            if (this.extras != null) {
                ++fieldCount;
            }
            if (this.operation != null) {
                ++fieldCount;
            }
            packer.packMapHeader(fieldCount);
            if (this.name != null) {
                packer.packString(NAME);
                packer.packString(this.name);
            }
            if (this.data != null) {
                packer.packString(DATA);
                if (this.data instanceof byte[]) {
                    byte[] byteData = (byte[])this.data;
                    packer.packBinaryHeader(byteData.length);
                    packer.writePayload(byteData);
                } else {
                    packer.packString(this.data.toString());
                }
            }
            if (this.encoding != null) {
                packer.packString(ENCODING);
                packer.packString(this.encoding);
            }
            if (this.extras != null) {
                packer.packString(EXTRAS);
                this.extras.write(packer);
            }
            if (this.operation != null) {
                packer.packString(OPERATION);
                this.operation.writeMsgpack(packer);
            }
        }

        JsonObject asJsonObject() {
            JsonObject json = new JsonObject();
            Object data = this.data;
            String encoding = this.encoding;
            if (data != null) {
                if (data instanceof byte[]) {
                    byte[] dataBytes = (byte[])data;
                    json.addProperty(DATA, new String(Base64Coder.encode(dataBytes)));
                    encoding = encoding == null ? "base64" : encoding + "/base64";
                } else {
                    json.addProperty(DATA, data.toString());
                }
                if (encoding != null) {
                    json.addProperty(ENCODING, encoding);
                }
            }
            if (this.name != null) {
                json.addProperty(NAME, this.name);
            }
            if (this.extras != null) {
                json.add(EXTRAS, (JsonElement)this.extras.asJsonObject());
            }
            if (this.operation != null) {
                json.add(OPERATION, (JsonElement)this.operation.asJsonObject());
            }
            return json;
        }
    }
}

