/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import android.content.Context;
import com.google.gson.JsonObject;
import io.ably.lib.push.ActivationContext;
import io.ably.lib.push.SharedPreferenceStorage;
import io.ably.lib.push.Storage;
import io.ably.lib.rest.DeviceDetails;
import io.ably.lib.types.Param;
import io.ably.lib.types.RegistrationToken;
import io.ably.lib.util.Base64Coder;
import io.ably.lib.util.Log;
import io.azam.ulidj.ULID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class LocalDevice
extends DeviceDetails {
    public String deviceSecret;
    public String deviceIdentityToken;
    private final Storage storage;
    private final ActivationContext activationContext;
    private static final String DEVICE_IDENTITY_HEADER = "X-Ably-DeviceToken";
    private static final String TAG = LocalDevice.class.getName();

    public LocalDevice(ActivationContext activationContext, Storage storage) {
        Log.v(TAG, "LocalDevice(): initialising");
        this.platform = "android";
        this.formFactor = LocalDevice.isTablet(activationContext.getContext()) ? "tablet" : "phone";
        this.activationContext = activationContext;
        this.push = new DeviceDetails.Push();
        this.storage = storage != null ? storage : new SharedPreferenceStorage(activationContext);
        this.loadPersisted();
    }

    @Override
    public JsonObject toJsonObject() {
        JsonObject o = super.toJsonObject();
        if (this.deviceSecret != null) {
            o.addProperty("deviceSecret", this.deviceSecret);
        }
        return o;
    }

    private void loadPersisted() {
        String id;
        this.id = id = this.storage.get("ABLY_DEVICE_ID", null);
        if (id != null) {
            Log.v(TAG, "loadPersisted(): existing deviceId found; id: " + id);
            this.deviceSecret = this.storage.get("ABLY_DEVICE_SECRET", null);
        } else {
            Log.v(TAG, "loadPersisted(): existing deviceId not found.");
        }
        this.clientId = this.storage.get("ABLY_CLIENT_ID", null);
        this.deviceIdentityToken = this.storage.get("ABLY_DEVICE_IDENTITY_TOKEN", null);
        RegistrationToken.Type type = RegistrationToken.Type.fromOrdinal(this.storage.get("ABLY_REGISTRATION_TOKEN_TYPE", -1));
        Log.d(TAG, "loadPersisted(): token type = " + (Object)((Object)type));
        if (type != null) {
            RegistrationToken token = null;
            String tokenString = this.storage.get("ABLY_REGISTRATION_TOKEN", null);
            Log.d(TAG, "loadPersisted(): token string = " + tokenString);
            if (tokenString != null) {
                token = new RegistrationToken(type, tokenString);
                this.setRegistrationToken(token);
            }
        }
    }

    RegistrationToken getRegistrationToken() {
        JsonObject recipient = this.push.recipient;
        if (recipient == null) {
            Log.v(TAG, "getRegistrationToken(): returning null because push.recipient is null");
            return null;
        }
        Log.v(TAG, "getRegistrationToken(): returning a new registration token because push.recipient is set");
        return new RegistrationToken(RegistrationToken.Type.fromName(recipient.get("transportType").getAsString()), recipient.get("registrationToken").getAsString());
    }

    private void setRegistrationToken(RegistrationToken token) {
        Log.v(TAG, "setRegistrationToken(): token=" + token);
        this.push.recipient = new JsonObject();
        this.push.recipient.addProperty("transportType", token.type.toName());
        this.push.recipient.addProperty("registrationToken", token.token);
    }

    private void clearRegistrationToken() {
        Log.v(TAG, "clearRegistrationToken()");
        this.push.recipient = null;
    }

    void setAndPersistRegistrationToken(RegistrationToken token) {
        Log.v(TAG, "setAndPersistRegistrationToken(): token=" + token);
        this.setRegistrationToken(token);
        this.storage.put("ABLY_REGISTRATION_TOKEN_TYPE", token.type.ordinal());
        this.storage.put("ABLY_REGISTRATION_TOKEN", token.token);
    }

    void setClientId(String clientId) {
        Log.v(TAG, "setClientId(): clientId=" + clientId);
        this.clientId = clientId;
        this.storage.put("ABLY_CLIENT_ID", clientId);
    }

    public void setDeviceIdentityToken(String token) {
        Log.v(TAG, "setDeviceIdentityToken(): token=" + token);
        this.deviceIdentityToken = token;
        this.storage.put("ABLY_DEVICE_IDENTITY_TOKEN", token);
    }

    boolean isCreated() {
        return this.id != null;
    }

    void create() {
        Log.v(TAG, "create()");
        this.id = ULID.random();
        this.storage.put("ABLY_DEVICE_ID", this.id);
        this.clientId = this.activationContext.clientId;
        this.storage.put("ABLY_CLIENT_ID", this.clientId);
        this.deviceSecret = LocalDevice.generateSecret();
        this.storage.put("ABLY_DEVICE_SECRET", this.deviceSecret);
    }

    public void reset() {
        Log.v(TAG, "reset()");
        this.id = null;
        this.deviceSecret = null;
        this.deviceIdentityToken = null;
        this.clientId = null;
        this.clearRegistrationToken();
        this.storage.clear(SharedPrefKeys.class.getDeclaredFields());
    }

    boolean isRegistered() {
        return this.deviceIdentityToken != null;
    }

    Param[] deviceIdentityHeaders() {
        Param[] paramArray;
        if (this.deviceIdentityToken != null) {
            Param[] paramArray2 = new Param[1];
            paramArray = paramArray2;
            paramArray2[0] = new Param(DEVICE_IDENTITY_HEADER, Base64Coder.encodeString(this.deviceIdentityToken));
        } else {
            paramArray = null;
        }
        return paramArray;
    }

    private static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    private static String generateSecret() {
        Log.v(TAG, "generateSecret()");
        byte[] entropy = new byte[64];
        new SecureRandom().nextBytes(entropy);
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] encodedhash = digest.digest(entropy);
        return Base64Coder.encodeToString(encodedhash);
    }

    private static class SharedPrefKeys {
        static final String DEVICE_ID = "ABLY_DEVICE_ID";
        static final String CLIENT_ID = "ABLY_CLIENT_ID";
        static final String DEVICE_SECRET = "ABLY_DEVICE_SECRET";
        static final String DEVICE_TOKEN = "ABLY_DEVICE_IDENTITY_TOKEN";
        static final String TOKEN_TYPE = "ABLY_REGISTRATION_TOKEN_TYPE";
        static final String TOKEN = "ABLY_REGISTRATION_TOKEN";

        private SharedPrefKeys() {
        }
    }
}

