/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import android.content.Context;
import io.ably.lib.push.LocalDevice;
import io.ably.lib.rest.AblyBase;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.util.Log;

public class AblyRest
extends AblyBase {
    private static final String TAG = AblyRest.class.getName();

    public AblyRest(String key) throws AblyException {
        super(key);
    }

    public AblyRest(ClientOptions options) throws AblyException {
        super(options);
    }

    public LocalDevice device() throws AblyException {
        return this.push.getLocalDevice();
    }

    public void setAndroidContext(Context context) throws AblyException {
        Log.v(TAG, "setAndroidContext(): context=" + context);
        this.platform.setAndroidContext(context);
        this.push.tryRequestRegistrationToken();
    }

    @Override
    protected void onClientIdSet(String clientId) {
        Log.v(TAG, "onClientIdSet(): clientId=" + clientId);
        if (this.push != null && this.platform.hasApplicationContext()) {
            try {
                this.push.getActivationContext().setClientId(clientId, true);
            }
            catch (AblyException ae) {
                Log.e(TAG, "unable to update local device state");
            }
        }
    }
}

