/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.rest;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.Http;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.rest.AblyBase;
import io.ably.lib.rest.RestAnnotations;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.PresenceSerializer;
import io.ably.lib.util.Crypto;

public class ChannelBase {
    public final String name;
    public final Presence presence;
    public final RestAnnotations annotations;
    private final AblyBase ably;
    private final String basePath;
    ChannelOptions options;

    public void publish(String name, Object data) throws AblyException {
        this.publish(this.ably.http, name, data);
    }

    void publish(Http http, String name, Object data) throws AblyException {
        this.publishImpl(http, name, data).sync();
    }

    public void publishAsync(String name, Object data, CompletionListener listener) {
        this.publishAsync(this.ably.http, name, data, listener);
    }

    void publishAsync(Http http, String name, Object data, CompletionListener listener) {
        this.publishImpl(http, name, data).async(new CompletionListener.ToCallback(listener));
    }

    private Http.Request<Void> publishImpl(Http http, String name, Object data) {
        return this.publishImpl(http, new Message[]{new Message(name, data)});
    }

    public void publish(Message[] messages) throws AblyException {
        this.publish(this.ably.http, messages);
    }

    void publish(Http http, Message[] messages) throws AblyException {
        this.publishImpl(http, messages).sync();
    }

    public void publishAsync(Message[] messages, CompletionListener listener) {
        this.publishAsync(this.ably.http, messages, listener);
    }

    void publishAsync(Http http, Message[] messages, CompletionListener listener) {
        this.publishImpl(http, messages).async(new CompletionListener.ToCallback(listener));
    }

    private Http.Request<Void> publishImpl(Http http, final Message[] messages) {
        return http.request(new Http.Execute<Void>(){

            @Override
            public void execute(HttpScheduler http, Callback<Void> callback) throws AblyException {
                boolean hasClientSuppliedId = false;
                for (Message message : messages) {
                    hasClientSuppliedId |= message.id != null;
                    ((ChannelBase)ChannelBase.this).ably.auth.checkClientId(message, true, false);
                    message.encode(ChannelBase.this.options);
                }
                if (!hasClientSuppliedId && ((ChannelBase)ChannelBase.this).ably.options.idempotentRestPublishing) {
                    String messageId = Crypto.getRandomId();
                    for (int i = 0; i < messages.length; ++i) {
                        messages[i].id = messageId + ':' + i;
                    }
                }
                HttpCore.RequestBody requestBody = ((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol ? MessageSerializer.asMsgpackRequest(messages) : MessageSerializer.asJsonRequest(messages);
                Param[] params = ((ChannelBase)ChannelBase.this).ably.options.addRequestIds ? Param.array(Crypto.generateRandomRequestId()) : null;
                http.post(ChannelBase.this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), params, requestBody, null, true, callback);
            }
        });
    }

    public PaginatedResult<Message> history(Param[] params) throws AblyException {
        return this.history(this.ably.http, params);
    }

    PaginatedResult<Message> history(Http http, Param[] params) throws AblyException {
        return this.historyImpl(http, params).sync();
    }

    public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        this.historyAsync(this.ably.http, params, callback);
    }

    void historyAsync(Http http, Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        this.historyImpl(http, params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<Message> historyImpl(Http http, Param[] initialParams) {
        HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        Param[] params = this.ably.options.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
        return new BasePaginatedQuery<Message>(http, this.basePath + "/messages", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    ChannelBase(AblyBase ably, String name, ChannelOptions options) throws AblyException {
        this.ably = ably;
        this.name = name;
        this.options = options;
        this.basePath = "/channels/" + HttpUtils.encodeURIComponent(name);
        this.presence = new Presence();
        this.annotations = new RestAnnotations(name, ably.http, ably.options, options);
    }

    public class Presence {
        public PaginatedResult<PresenceMessage> get(Param[] params) throws AblyException {
            return this.get(((ChannelBase)ChannelBase.this).ably.http, params);
        }

        PaginatedResult<PresenceMessage> get(Http http, Param[] params) throws AblyException {
            return this.getImpl(http, params).sync();
        }

        public void getAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.getAsync(((ChannelBase)ChannelBase.this).ably.http, params, callback);
        }

        void getAsync(Http http, Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.getImpl(http, params).async(callback);
        }

        private BasePaginatedQuery.ResultRequest<PresenceMessage> getImpl(Http http, Param[] initialParams) {
            HttpCore.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(ChannelBase.this.options);
            Param[] params = ((ChannelBase)ChannelBase.this).ably.options.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
            return new BasePaginatedQuery<PresenceMessage>(http, ChannelBase.this.basePath + "/presence", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), params, bodyHandler).get();
        }

        public PaginatedResult<PresenceMessage> history(Param[] params) throws AblyException {
            return this.history(((ChannelBase)ChannelBase.this).ably.http, params);
        }

        PaginatedResult<PresenceMessage> history(Http http, Param[] params) throws AblyException {
            return this.historyImpl(http, params).sync();
        }

        public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.historyAsync(((ChannelBase)ChannelBase.this).ably.http, params, callback);
        }

        void historyAsync(Http http, Param[] params, Callback<AsyncPaginatedResult<PresenceMessage>> callback) {
            this.historyImpl(http, params).async(callback);
        }

        private BasePaginatedQuery.ResultRequest<PresenceMessage> historyImpl(Http http, Param[] initialParams) {
            HttpCore.BodyHandler<PresenceMessage> bodyHandler = PresenceSerializer.getPresenceResponseHandler(ChannelBase.this.options);
            Param[] params = ((ChannelBase)ChannelBase.this).ably.options.addRequestIds ? Param.set(initialParams, Crypto.generateRandomRequestId()) : initialParams;
            return new BasePaginatedQuery<PresenceMessage>(http, ChannelBase.this.basePath + "/presence/history", HttpUtils.defaultAcceptHeaders(((ChannelBase)ChannelBase.this).ably.options.useBinaryProtocol), params, bodyHandler).get();
        }
    }
}

