/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.firebase.messaging.FirebaseMessaging;
import io.ably.lib.push.ActivationStateMachine;
import io.ably.lib.push.LocalDevice;
import io.ably.lib.push.Storage;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.RegistrationToken;
import io.ably.lib.util.Log;
import java.util.WeakHashMap;

public class ActivationContext {
    protected AblyRest ably;
    protected String clientId;
    protected ActivationStateMachine activationStateMachine;
    protected LocalDevice localDevice;
    protected final SharedPreferences prefs;
    protected final Context context;
    private static WeakHashMap<Context, ActivationContext> activationContexts = new WeakHashMap();
    private static final String TAG = ActivationContext.class.getName();

    public ActivationContext(Context context) {
        this.context = context;
        this.prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    Context getContext() {
        return this.context;
    }

    SharedPreferences getPreferences() {
        return this.prefs;
    }

    public synchronized LocalDevice getLocalDevice() {
        if (this.localDevice == null) {
            Log.v(TAG, "getLocalDevice(): creating new instance and returning that");
            Storage storage = this.ably != null ? this.ably.options.localStorage : null;
            this.localDevice = new LocalDevice(this, storage);
        } else {
            Log.v(TAG, "getLocalDevice(): returning existing instance");
        }
        return this.localDevice;
    }

    public synchronized void setActivationStateMachine(ActivationStateMachine activationStateMachine) {
        Log.v(TAG, "setActivationStateMachine(): activationStateMachine=" + activationStateMachine);
        this.activationStateMachine = activationStateMachine;
    }

    public synchronized ActivationStateMachine getActivationStateMachine() {
        if (this.activationStateMachine == null) {
            Log.v(TAG, "getActivationStateMachine(): creating new instance and returning that");
            this.activationStateMachine = new ActivationStateMachine(this);
        } else {
            Log.v(TAG, "getActivationStateMachine(): returning existing instance");
        }
        return this.activationStateMachine;
    }

    public void setAbly(AblyRest ably) {
        this.ably = ably;
        this.clientId = ably.auth.clientId;
    }

    AblyRest getAbly() throws AblyException {
        if (this.ably != null) {
            Log.v(TAG, "getAbly(): returning existing Ably instance");
            return this.ably;
        }
        Log.v(TAG, "getAbly(): creating new Ably instance");
        String deviceIdentityToken = this.getLocalDevice().deviceIdentityToken;
        if (deviceIdentityToken == null) {
            Log.e(TAG, "getAbly(): unable to create Ably instance using deviceIdentityToken");
            throw AblyException.fromErrorInfo(new ErrorInfo("Unable to get Ably library instance; no device identity token", 40000, 400));
        }
        Log.v(TAG, "getAbly(): returning Ably instance using deviceIdentityToken");
        this.ably = new AblyRest(deviceIdentityToken);
        return this.ably;
    }

    public boolean setClientId(String clientId, boolean propagateGotPushDeviceDetails) {
        boolean updated;
        Log.v(TAG, "setClientId(): clientId=" + clientId + ", propagateGotPushDeviceDetails=" + propagateGotPushDeviceDetails);
        boolean bl = updated = !clientId.equals(this.clientId);
        if (updated) {
            this.clientId = clientId;
            if (this.localDevice != null) {
                Log.v(TAG, "setClientId(): local device exists");
                this.localDevice.setClientId(clientId);
                if (this.localDevice.isRegistered() && this.activationStateMachine != null && propagateGotPushDeviceDetails) {
                    this.activationStateMachine.handleEvent(new ActivationStateMachine.GotPushDeviceDetails());
                }
            } else {
                Log.v(TAG, "setClientId(): local device doest not exist");
            }
        }
        return updated;
    }

    public void onNewRegistrationToken(RegistrationToken.Type type, String token) {
        Log.v(TAG, "onNewRegistrationToken(): type=" + (Object)((Object)type) + ", token=" + token);
        LocalDevice localDevice = this.getLocalDevice();
        RegistrationToken previous = localDevice.getRegistrationToken();
        if (previous != null) {
            if (previous.type != type) {
                Log.e(TAG, "trying to register device with " + (Object)((Object)type) + ", but it was already registered with " + (Object)((Object)previous.type));
                return;
            }
            if (previous.token.equals(token)) {
                return;
            }
        }
        Log.v(TAG, "onNewRegistrationToken(): updating token");
        localDevice.setAndPersistRegistrationToken(new RegistrationToken(type, token));
        this.getActivationStateMachine().handleEvent(new ActivationStateMachine.GotPushDeviceDetails());
    }

    public void reset() {
        Log.v(TAG, "reset()");
        this.ably = null;
        this.getActivationStateMachine().reset();
        this.activationStateMachine = null;
        this.getLocalDevice().reset();
        this.localDevice = null;
    }

    public static ActivationContext getActivationContext(Context applicationContext) {
        return ActivationContext.getActivationContext(applicationContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivationContext getActivationContext(Context applicationContext, AblyRest ably) {
        ActivationContext activationContext;
        WeakHashMap<Context, ActivationContext> weakHashMap = activationContexts;
        synchronized (weakHashMap) {
            activationContext = activationContexts.get(applicationContext);
            if (activationContext == null) {
                Log.v(TAG, "getActivationContext(): creating new ActivationContext for this application");
                activationContext = new ActivationContext(applicationContext);
                activationContexts.put(applicationContext, activationContext);
            } else {
                Log.v(TAG, "getActivationContext(): returning existing ActivationContext for this application");
            }
            if (ably != null) {
                Log.v(TAG, "Setting Ably instance on the activation context");
                activationContext.setAbly(ably);
            } else {
                Log.v(TAG, "Not setting Ably instance on the activation context");
            }
        }
        return activationContext;
    }

    protected void getRegistrationToken(Callback<String> callback) {
        Log.v(TAG, "getRegistrationToken(): callback=" + callback);
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener(task -> {
            Log.v(TAG, "getRegistrationToken(): FirebaseMessaging#getToken() completed: task=" + task);
            if (task.isSuccessful()) {
                String registrationToken = (String)task.getResult();
                callback.onSuccess(registrationToken);
            } else {
                callback.onError(ErrorInfo.fromThrowable(task.getException()));
            }
        });
    }

    public static void setActivationContext(Context applicationContext, ActivationContext activationContext) {
        Log.v(TAG, "setActivationContext(): applicationContext=" + applicationContext + ", activationContext=" + activationContext);
        activationContexts.put(applicationContext, activationContext);
    }
}

