/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.realtime;

import io.ably.lib.http.BasePaginatedQuery;
import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.ChannelEvent;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.realtime.ChannelStateListener;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.realtime.Presence;
import io.ably.lib.transport.ConnectionManager;
import io.ably.lib.transport.Defaults;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.AsyncPaginatedResult;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ChannelMode;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.ChannelProperties;
import io.ably.lib.types.DecodingContext;
import io.ably.lib.types.DeltaExtras;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PaginatedResult;
import io.ably.lib.types.Param;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.ProtocolMessage;
import io.ably.lib.util.CollectionUtils;
import io.ably.lib.util.EventEmitter;
import io.ably.lib.util.Log;
import io.ably.lib.util.Multicaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ChannelBase
extends EventEmitter<ChannelEvent, ChannelStateListener> {
    public final String name;
    public final Presence presence;
    public ChannelState state;
    public ErrorInfo reason;
    public ChannelProperties properties = new ChannelProperties();
    private boolean attachResume;
    private Timer attachTimer;
    private Timer reattachTimer;
    static ErrorInfo REASON_NOT_ATTACHED = new ErrorInfo("Channel not attached", 400, 90001);
    private MessageMulticaster listeners = new MessageMulticaster();
    private HashMap<String, MessageMulticaster> eventListeners = new HashMap();
    private static final String KEY_UNTIL_ATTACH = "untilAttach";
    private static final String KEY_FROM_SERIAL = "fromSerial";
    private List<ConnectionManager.QueuedMessage> queuedMessages;
    private static final String TAG = Channel.class.getName();
    final AblyRealtime ably;
    final String basePath;
    ChannelOptions options;
    String syncChannelSerial;
    private Map<String, String> params;
    private Set<ChannelMode> modes;
    private String lastPayloadMessageId;
    private String lastPayloadProtocolMessageChannelSerial;
    private boolean decodeFailureRecoveryInProgress;
    private final DecodingContext decodingContext;

    private void setState(ChannelState newState, ErrorInfo reason) {
        this.setState(newState, reason, false, true);
    }

    private void setState(ChannelState newState, ErrorInfo reason, boolean resumed) {
        this.setState(newState, reason, resumed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ChannelState newState, ErrorInfo reason, boolean resumed, boolean notifyStateChange) {
        ChannelStateListener.ChannelStateChange stateChange;
        Log.v(TAG, "setState(): channel = " + this.name + "; setting " + (Object)((Object)newState));
        ChannelBase channelBase = this;
        synchronized (channelBase) {
            stateChange = new ChannelStateListener.ChannelStateChange(newState, this.state, reason, resumed);
            this.state = stateChange.current;
            this.reason = stateChange.reason;
        }
        if (notifyStateChange) {
            this.emit(newState, stateChange);
        }
    }

    public void attach() throws AblyException {
        this.attach(null);
    }

    public void attach(CompletionListener listener) throws AblyException {
        this.attach(false, listener);
    }

    private void attach(boolean forceReattach, CompletionListener listener) {
        this.clearAttachTimers();
        this.attachWithTimeout(forceReattach, listener);
    }

    private void attachImpl(boolean forceReattach, CompletionListener listener) throws AblyException {
        ConnectionManager connectionManager;
        Log.v(TAG, "attach(); channel = " + this.name);
        if (!forceReattach) {
            switch (this.state) {
                case attaching: {
                    if (listener != null) {
                        this.on(new ChannelStateCompletionListener(listener, ChannelState.attached, ChannelState.failed));
                    }
                    return;
                }
                case attached: {
                    ChannelBase.callCompletionListenerSuccess(listener);
                    return;
                }
            }
        }
        if (!(connectionManager = this.ably.connection.connectionManager).isActive()) {
            throw AblyException.fromErrorInfo(connectionManager.getStateErrorInfo());
        }
        Log.v(TAG, "attach(); channel = " + this.name + "; sending ATTACH request");
        ProtocolMessage attachMessage = new ProtocolMessage(ProtocolMessage.Action.attach, this.name);
        if (this.options != null) {
            if (this.options.hasParams()) {
                attachMessage.params = CollectionUtils.copy(this.options.params);
            }
            if (this.options.hasModes()) {
                attachMessage.setFlags(this.options.getModeFlags());
            }
        }
        if (this.decodeFailureRecoveryInProgress) {
            attachMessage.channelSerial = this.lastPayloadProtocolMessageChannelSerial;
        }
        if (listener != null) {
            this.on(new ChannelStateCompletionListener(listener, ChannelState.attached, ChannelState.failed));
        }
        if (this.attachResume) {
            attachMessage.setFlag(ProtocolMessage.Flag.attach_resume);
        }
        this.setState(ChannelState.attaching, null);
        connectionManager.send(attachMessage, true, null);
    }

    public void detach() throws AblyException {
        this.detach(null);
    }

    public void detach(CompletionListener listener) throws AblyException {
        this.clearAttachTimers();
        this.detachWithTimeout(listener);
    }

    private void detachImpl(CompletionListener listener) throws AblyException {
        Log.v(TAG, "detach(); channel = " + this.name);
        switch (this.state) {
            case initialized: 
            case detached: {
                ChannelBase.callCompletionListenerSuccess(listener);
                return;
            }
            case detaching: {
                if (listener != null) {
                    this.on(new ChannelStateCompletionListener(listener, ChannelState.detached, ChannelState.failed));
                }
                return;
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw AblyException.fromErrorInfo(connectionManager.getStateErrorInfo());
        }
        ProtocolMessage detachMessage = new ProtocolMessage(ProtocolMessage.Action.detach, this.name);
        if (listener != null) {
            this.on(new ChannelStateCompletionListener(listener, ChannelState.detached, ChannelState.failed));
        }
        this.attachResume = false;
        this.setState(ChannelState.detaching, null);
        connectionManager.send(detachMessage, true, null);
    }

    public void sync() throws AblyException {
        Log.v(TAG, "sync(); channel = " + this.name);
        switch (this.state) {
            case initialized: 
            case detached: 
            case detaching: {
                throw AblyException.fromErrorInfo(new ErrorInfo("Unable to sync to channel; not attached", 40000));
            }
        }
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        if (!connectionManager.isActive()) {
            throw AblyException.fromErrorInfo(connectionManager.getStateErrorInfo());
        }
        ProtocolMessage syncMessage = new ProtocolMessage(ProtocolMessage.Action.sync, this.name);
        syncMessage.channelSerial = this.syncChannelSerial;
        connectionManager.send(syncMessage, true, null);
    }

    private static void callCompletionListenerSuccess(CompletionListener listener) {
        if (listener != null) {
            try {
                listener.onSuccess();
            }
            catch (Throwable t) {
                Log.e(TAG, "Unexpected exception calling CompletionListener", t);
            }
        }
    }

    private static void callCompletionListenerError(CompletionListener listener, ErrorInfo err) {
        if (listener != null) {
            try {
                listener.onError(err);
            }
            catch (Throwable t) {
                Log.e(TAG, "Unexpected exception calling CompletionListener", t);
            }
        }
    }

    private void setAttached(ProtocolMessage message) {
        this.clearAttachTimers();
        boolean resumed = message.hasFlag(ProtocolMessage.Flag.resumed);
        Log.v(TAG, "setAttached(); channel = " + this.name + ", resumed = " + resumed);
        this.properties.attachSerial = message.channelSerial;
        this.params = message.params;
        this.modes = ChannelMode.toSet(message.flags);
        if (this.state == ChannelState.attached) {
            Log.v(TAG, String.format(Locale.ROOT, "Server initiated attach for channel %s", this.name));
            this.emitUpdate(null, resumed);
        } else {
            this.attachResume = true;
            this.setState(ChannelState.attached, message.error, resumed);
            this.sendQueuedMessages();
            this.presence.setAttached(message.hasFlag(ProtocolMessage.Flag.has_presence));
        }
    }

    private void setDetached(ErrorInfo reason) {
        this.clearAttachTimers();
        Log.v(TAG, "setDetached(); channel = " + this.name);
        this.presence.setDetached(reason);
        this.setState(ChannelState.detached, reason);
        this.failQueuedMessages(reason);
    }

    private void setFailed(ErrorInfo reason) {
        this.clearAttachTimers();
        Log.v(TAG, "setFailed(); channel = " + this.name);
        this.presence.setDetached(reason);
        this.attachResume = false;
        this.setState(ChannelState.failed, reason);
        this.failQueuedMessages(reason);
    }

    private synchronized void clearAttachTimers() {
        Timer[] timers = new Timer[]{this.attachTimer, this.reattachTimer};
        this.reattachTimer = null;
        this.attachTimer = null;
        for (Timer t : timers) {
            if (t == null) continue;
            t.cancel();
            t.purge();
        }
    }

    private void attachWithTimeout(CompletionListener listener) throws AblyException {
        this.attachWithTimeout(false, listener);
    }

    private synchronized void attachWithTimeout(boolean forceReattach, final CompletionListener listener) {
        Timer currentAttachTimer;
        try {
            currentAttachTimer = new Timer();
        }
        catch (Throwable t) {
            ChannelBase.callCompletionListenerError(listener, ErrorInfo.fromThrowable(t));
            return;
        }
        this.attachTimer = currentAttachTimer;
        try {
            this.attachImpl(forceReattach, new CompletionListener(){

                @Override
                public void onSuccess() {
                    ChannelBase.this.clearAttachTimers();
                    ChannelBase.callCompletionListenerSuccess(listener);
                }

                @Override
                public void onError(ErrorInfo reason) {
                    ChannelBase.this.clearAttachTimers();
                    ChannelBase.callCompletionListenerError(listener, reason);
                }
            });
        }
        catch (AblyException e) {
            this.attachTimer = null;
            ChannelBase.callCompletionListenerError(listener, e.errorInfo);
        }
        if (this.attachTimer == null) {
            return;
        }
        final Timer inProgressTimer = currentAttachTimer;
        this.attachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String errorMessage = String.format(Locale.ROOT, "Attach timed out for channel %s", ChannelBase.this.name);
                Log.v(TAG, errorMessage);
                ChannelBase channelBase = ChannelBase.this;
                synchronized (channelBase) {
                    if (ChannelBase.this.attachTimer != inProgressTimer) {
                        return;
                    }
                    ChannelBase.this.attachTimer = null;
                    if (ChannelBase.this.state == ChannelState.attaching) {
                        ChannelBase.this.setSuspended(new ErrorInfo(errorMessage, 91200), true);
                        ChannelBase.this.reattachAfterTimeout();
                    }
                }
            }
        }, Defaults.realtimeRequestTimeout);
    }

    private synchronized void reattachAfterTimeout() {
        Timer currentReattachTimer;
        try {
            currentReattachTimer = new Timer();
        }
        catch (Throwable t) {
            return;
        }
        this.reattachTimer = currentReattachTimer;
        final Timer inProgressTimer = currentReattachTimer;
        this.reattachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelBase channelBase = ChannelBase.this;
                synchronized (channelBase) {
                    if (inProgressTimer != ChannelBase.this.reattachTimer) {
                        return;
                    }
                    ChannelBase.this.reattachTimer = null;
                    if (ChannelBase.this.state == ChannelState.suspended) {
                        try {
                            ChannelBase.this.attachWithTimeout(null);
                        }
                        catch (AblyException e) {
                            Log.e(TAG, "Reattach channel failed; channel = " + ChannelBase.this.name, e);
                        }
                    }
                }
            }
        }, this.ably.options.channelRetryTimeout);
    }

    private synchronized void detachWithTimeout(final CompletionListener listener) {
        Timer currentDetachTimer;
        final ChannelState originalState = this.state;
        try {
            currentDetachTimer = new Timer();
        }
        catch (Throwable t) {
            ChannelBase.callCompletionListenerError(listener, ErrorInfo.fromThrowable(t));
            return;
        }
        this.attachTimer = currentDetachTimer;
        try {
            this.detachImpl(new CompletionListener(){

                @Override
                public void onSuccess() {
                    ChannelBase.this.clearAttachTimers();
                    ChannelBase.callCompletionListenerSuccess(listener);
                }

                @Override
                public void onError(ErrorInfo reason) {
                    ChannelBase.this.clearAttachTimers();
                    ChannelBase.callCompletionListenerError(listener, reason);
                }
            });
        }
        catch (AblyException e) {
            this.attachTimer = null;
        }
        if (this.attachTimer == null) {
            return;
        }
        final Timer inProgressTimer = currentDetachTimer;
        this.attachTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelBase channelBase = ChannelBase.this;
                synchronized (channelBase) {
                    if (inProgressTimer != ChannelBase.this.attachTimer) {
                        return;
                    }
                    ChannelBase.this.attachTimer = null;
                    if (ChannelBase.this.state == ChannelState.detaching) {
                        ErrorInfo reason = new ErrorInfo("Detach operation timed out", 90007);
                        ChannelBase.callCompletionListenerError(listener, reason);
                        ChannelBase.this.setState(originalState, reason);
                    }
                }
            }
        }, Defaults.realtimeRequestTimeout);
    }

    public void setConnected() {
        if (this.state == ChannelState.attached) {
            try {
                this.sync();
            }
            catch (AblyException e) {
                Log.e(TAG, "setConnected(): Unable to sync; channel = " + this.name, e);
            }
        } else if (this.state == ChannelState.suspended) {
            try {
                this.attachWithTimeout(null);
            }
            catch (AblyException e) {
                Log.e(TAG, "setConnected(): Unable to initiate attach; channel = " + this.name, e);
            }
        }
    }

    public void setConnectionFailed(ErrorInfo reason) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            this.setFailed(reason);
        }
    }

    public void setConnectionClosed(ErrorInfo reason) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            this.setDetached(reason);
        }
    }

    public synchronized void setSuspended(ErrorInfo reason, boolean notifyStateChange) {
        this.clearAttachTimers();
        if (this.state == ChannelState.attached || this.state == ChannelState.attaching) {
            Log.v(TAG, "setSuspended(); channel = " + this.name);
            this.presence.setSuspended(reason);
            this.setState(ChannelState.suspended, reason, false, notifyStateChange);
            this.failQueuedMessages(reason);
        }
    }

    @Override
    protected void apply(ChannelStateListener listener, ChannelEvent event, Object ... args) {
        try {
            listener.onChannelStateChanged((ChannelStateListener.ChannelStateChange)args[0]);
        }
        catch (Throwable t) {
            Log.e(TAG, "Unexpected exception calling ChannelStateListener", t);
        }
    }

    public synchronized void unsubscribe() {
        Log.v(TAG, "unsubscribe(); channel = " + this.name);
        this.listeners.clear();
        this.eventListeners.clear();
    }

    public synchronized void subscribe(MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name);
        this.listeners.add(listener);
        this.attach();
    }

    public synchronized void unsubscribe(MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name);
        this.listeners.remove(listener);
        for (MessageMulticaster multicaster : this.eventListeners.values()) {
            multicaster.remove(listener);
        }
    }

    public synchronized void subscribe(String name, MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name + "; event = " + name);
        this.subscribeImpl(name, listener);
        this.attach();
    }

    public synchronized void unsubscribe(String name, MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name + "; event = " + name);
        this.unsubscribeImpl(name, listener);
    }

    public synchronized void subscribe(String[] names, MessageListener listener) throws AblyException {
        Log.v(TAG, "subscribe(); channel = " + this.name + "; (multiple events)");
        for (String name : names) {
            this.subscribeImpl(name, listener);
        }
        this.attach();
    }

    public synchronized void unsubscribe(String[] names, MessageListener listener) {
        Log.v(TAG, "unsubscribe(); channel = " + this.name + "; (multiple events)");
        for (String name : names) {
            this.unsubscribeImpl(name, listener);
        }
    }

    private void onMessage(ProtocolMessage protocolMessage) {
        DeltaExtras deltaExtras;
        Log.v(TAG, "onMessage(); channel = " + this.name);
        Message[] messages = protocolMessage.messages;
        Message firstMessage = messages[0];
        Message lastMessage = messages[messages.length - 1];
        DeltaExtras deltaExtras2 = deltaExtras = null == firstMessage.extras ? null : firstMessage.extras.getDelta();
        if (null != deltaExtras && !deltaExtras.getFrom().equals(this.lastPayloadMessageId)) {
            Log.e(TAG, String.format(Locale.ROOT, "Delta message decode failure - previous message not available. Message id = %s, channel = %s", firstMessage.id, this.name));
            this.startDecodeFailureRecovery();
            return;
        }
        for (int i = 0; i < messages.length; ++i) {
            Message msg = messages[i];
            if (msg.connectionId == null) {
                msg.connectionId = protocolMessage.connectionId;
            }
            if (msg.timestamp == 0L) {
                msg.timestamp = protocolMessage.timestamp;
            }
            if (msg.id == null) {
                msg.id = protocolMessage.id + ':' + i;
            }
            try {
                msg.decode(this.options, this.decodingContext);
            }
            catch (MessageDecodeException e) {
                if (e.errorInfo.code == 40018) {
                    Log.e(TAG, String.format(Locale.ROOT, "Delta message decode failure - %s. Message id = %s, channel = %s", e.errorInfo.message, msg.id, this.name));
                    this.startDecodeFailureRecovery();
                    for (int j = i + 1; j < messages.length; ++j) {
                        String jId = messages[j].id;
                        String jIdToLog = null == jId ? protocolMessage.id + ':' + j : jId;
                        Log.v(TAG, String.format(Locale.ROOT, "Delta recovery in progress - message skipped. Message id = %s, channel = %s", jIdToLog, this.name));
                    }
                    return;
                }
                Log.e(TAG, String.format(Locale.ROOT, "Message decode failure - %s. Message id = %s, channel = %s", e.errorInfo.message, msg.id, this.name));
            }
            MessageMulticaster listeners = this.eventListeners.get(msg.name);
            if (listeners == null) continue;
            listeners.onMessage(msg);
        }
        this.lastPayloadMessageId = lastMessage.id;
        this.lastPayloadProtocolMessageChannelSerial = protocolMessage.channelSerial;
        for (Message msg : messages) {
            this.listeners.onMessage(msg);
        }
    }

    private void startDecodeFailureRecovery() {
        if (this.decodeFailureRecoveryInProgress) {
            return;
        }
        Log.w(TAG, "Starting delta decode failure recovery process");
        this.decodeFailureRecoveryInProgress = true;
        this.attach(true, new CompletionListener(){

            @Override
            public void onSuccess() {
                ChannelBase.this.decodeFailureRecoveryInProgress = false;
            }

            @Override
            public void onError(ErrorInfo reason) {
                ChannelBase.this.decodeFailureRecoveryInProgress = false;
            }
        });
    }

    private void onPresence(ProtocolMessage message, String syncChannelSerial) {
        Log.v(TAG, "onPresence(); channel = " + this.name + "; syncChannelSerial = " + syncChannelSerial);
        PresenceMessage[] messages = message.presence;
        for (int i = 0; i < messages.length; ++i) {
            PresenceMessage msg = messages[i];
            try {
                msg.decode(this.options);
            }
            catch (MessageDecodeException e) {
                Log.e(TAG, String.format(Locale.ROOT, "%s on channel %s", e.errorInfo.message, this.name));
            }
            if (msg.connectionId == null) {
                msg.connectionId = message.connectionId;
            }
            if (msg.timestamp == 0L) {
                msg.timestamp = message.timestamp;
            }
            if (msg.id != null) continue;
            msg.id = message.id + ':' + i;
        }
        this.presence.setPresence(messages, true, syncChannelSerial);
    }

    private void onSync(ProtocolMessage message) {
        Log.v(TAG, "onSync(); channel = " + this.name);
        if (message.presence != null) {
            this.syncChannelSerial = message.channelSerial;
            this.onPresence(message, this.syncChannelSerial);
        }
    }

    private void subscribeImpl(String name, MessageListener listener) throws AblyException {
        MessageMulticaster listeners = this.eventListeners.get(name);
        if (listeners == null) {
            listeners = new MessageMulticaster();
            this.eventListeners.put(name, listeners);
        }
        listeners.add(listener);
    }

    private void unsubscribeImpl(String name, MessageListener listener) {
        MessageMulticaster listeners = this.eventListeners.get(name);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eventListeners.remove(name);
            }
        }
    }

    public void publish(String name, Object data) throws AblyException {
        this.publish(name, data, null);
    }

    public void publish(Message message) throws AblyException {
        this.publish(message, null);
    }

    public void publish(Message[] messages) throws AblyException {
        this.publish(messages, null);
    }

    public void publish(String name, Object data, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(String, Object); channel = " + this.name + "; event = " + name);
        this.publish(new Message[]{new Message(name, data)}, listener);
    }

    public void publish(Message message, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(Message); channel = " + this.name + "; event = " + message.name);
        this.publish(new Message[]{message}, listener);
    }

    public synchronized void publish(Message[] messages, CompletionListener listener) throws AblyException {
        Log.v(TAG, "publish(Message[]); channel = " + this.name);
        ConnectionManager connectionManager = this.ably.connection.connectionManager;
        ConnectionManager.State connectionState = connectionManager.getConnectionState();
        boolean queueMessages = this.ably.options.queueMessages;
        if (!connectionManager.isActive() || connectionState.queueEvents && !queueMessages) {
            throw AblyException.fromErrorInfo(connectionState.defaultErrorInfo);
        }
        boolean connected = connectionState.sendEvents;
        try {
            for (Message message : messages) {
                this.ably.auth.checkClientId(message, true, connected);
                message.encode(this.options);
            }
        }
        catch (AblyException e) {
            ChannelBase.callCompletionListenerError(listener, e.errorInfo);
            return;
        }
        ProtocolMessage msg = new ProtocolMessage(ProtocolMessage.Action.message, this.name);
        msg.messages = messages;
        switch (this.state) {
            case failed: 
            case suspended: {
                throw AblyException.fromErrorInfo(new ErrorInfo("Unable to publish in failed or suspended state", 400, 40000));
            }
        }
        connectionManager.send(msg, queueMessages, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedMessages() {
        Log.v(TAG, "sendQueuedMessages()");
        ArrayList<FailedMessage> failedMessages = new ArrayList<FailedMessage>();
        ChannelBase channelBase = this;
        synchronized (channelBase) {
            boolean queueMessages = this.ably.options.queueMessages;
            ConnectionManager connectionManager = this.ably.connection.connectionManager;
            for (ConnectionManager.QueuedMessage msg : this.queuedMessages) {
                try {
                    connectionManager.send(msg.msg, queueMessages, msg.listener);
                }
                catch (AblyException e) {
                    Log.e(TAG, "sendQueuedMessages(): Unexpected exception sending message", e);
                    if (msg.listener == null) continue;
                    failedMessages.add(new FailedMessage(msg, e.errorInfo));
                }
            }
            this.queuedMessages.clear();
        }
        for (FailedMessage failed : failedMessages) {
            ChannelBase.callCompletionListenerError(failed.msg.listener, failed.reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failQueuedMessages(ErrorInfo reason) {
        Log.v(TAG, "failQueuedMessages()");
        ArrayList<FailedMessage> failedMessages = new ArrayList<FailedMessage>();
        ChannelBase channelBase = this;
        synchronized (channelBase) {
            for (ConnectionManager.QueuedMessage msg : this.queuedMessages) {
                if (msg.listener == null) continue;
                failedMessages.add(new FailedMessage(msg, reason));
            }
            this.queuedMessages.clear();
        }
        for (FailedMessage failed : failedMessages) {
            ChannelBase.callCompletionListenerError(failed.msg.listener, failed.reason);
        }
    }

    static Param[] replacePlaceholderParams(Channel channel, Param[] placeholderParams) throws AblyException {
        if (placeholderParams == null) {
            return null;
        }
        HashSet<Param> params = new HashSet<Param>();
        for (int i = 0; i < placeholderParams.length; ++i) {
            Param param = placeholderParams[i];
            if (KEY_UNTIL_ATTACH.equals(param.key)) {
                if ("true".equalsIgnoreCase(param.value)) {
                    if (channel.state != ChannelState.attached) {
                        throw AblyException.fromErrorInfo(new ErrorInfo("option untilAttach requires the channel to be attached", 40000, 400));
                    }
                    params.add(new Param(KEY_FROM_SERIAL, channel.properties.attachSerial));
                    continue;
                }
                if ("false".equalsIgnoreCase(param.value)) continue;
                throw AblyException.fromErrorInfo(new ErrorInfo("option untilAttach is invalid. \"true\" or \"false\" expected", 40000, 400));
            }
            params.add(param);
        }
        return params.toArray(new Param[params.size()]);
    }

    public PaginatedResult<Message> history(Param[] params) throws AblyException {
        return this.historyImpl(params).sync();
    }

    public void historyAsync(Param[] params, Callback<AsyncPaginatedResult<Message>> callback) {
        this.historyImpl(params).async(callback);
    }

    private BasePaginatedQuery.ResultRequest<Message> historyImpl(Param[] params) {
        try {
            params = ChannelBase.replacePlaceholderParams((Channel)this, params);
        }
        catch (AblyException e) {
            return new BasePaginatedQuery.ResultRequest.Failed<Message>(e);
        }
        HttpCore.BodyHandler<Message> bodyHandler = MessageSerializer.getMessageResponseHandler(this.options);
        return new BasePaginatedQuery<Message>(this.ably.http, this.basePath + "/history", HttpUtils.defaultAcceptHeaders(this.ably.options.useBinaryProtocol), params, bodyHandler).get();
    }

    public void setOptions(ChannelOptions options) throws AblyException {
        this.setOptions(options, null);
    }

    public void setOptions(ChannelOptions options, CompletionListener listener) throws AblyException {
        this.options = options;
        if (this.shouldReattachToSetOptions(options)) {
            this.attach(true, listener);
        } else {
            ChannelBase.callCompletionListenerSuccess(listener);
        }
    }

    boolean shouldReattachToSetOptions(ChannelOptions options) {
        return !(this.state != ChannelState.attached && this.state != ChannelState.attaching || !options.hasModes() && !options.hasParams());
    }

    public Map<String, String> getParams() {
        return CollectionUtils.copy(this.params);
    }

    public ChannelMode[] getModes() {
        return this.modes.toArray(new ChannelMode[this.modes.size()]);
    }

    ChannelBase(AblyRealtime ably, String name, ChannelOptions options) throws AblyException {
        Log.v(TAG, "RealtimeChannel(); channel = " + name);
        this.ably = ably;
        this.name = name;
        this.basePath = "/channels/" + HttpUtils.encodeURIComponent(name);
        this.setOptions(options);
        this.presence = new Presence((Channel)this);
        this.attachResume = false;
        this.state = ChannelState.initialized;
        this.queuedMessages = new ArrayList<ConnectionManager.QueuedMessage>();
        this.decodingContext = new DecodingContext();
    }

    void onChannelMessage(ProtocolMessage msg) {
        block1 : switch (msg.action) {
            case attached: {
                this.setAttached(msg);
                break;
            }
            case detach: 
            case detached: {
                ChannelState oldState = this.state;
                switch (oldState) {
                    case attached: {
                        this.setDetached(msg.error != null ? msg.error : REASON_NOT_ATTACHED);
                        Log.v(TAG, String.format(Locale.ROOT, "Server initiated detach for channel %s; attempting reattach", this.name));
                        try {
                            this.attachWithTimeout(null);
                        }
                        catch (AblyException e) {
                            Log.e(TAG, "Attempting reattach threw exception", e);
                            this.setDetached(e.errorInfo);
                        }
                        break block1;
                    }
                    case attaching: {
                        Log.v(TAG, String.format(Locale.ROOT, "Server initiated detach for channel %s whilst attaching; moving to suspended", this.name));
                        this.setSuspended(msg.error, true);
                        this.reattachAfterTimeout();
                        break block1;
                    }
                    case detaching: {
                        this.setDetached(msg.error != null ? msg.error : REASON_NOT_ATTACHED);
                        break block1;
                    }
                }
                break;
            }
            case message: {
                if (this.state == ChannelState.attached) {
                    this.onMessage(msg);
                    break;
                }
                String errorMsgPrefix = this.decodeFailureRecoveryInProgress ? "Delta recovery in progress - message skipped." : "Message skipped on a channel that is not ATTACHED.";
                for (Message skippedMessage : msg.messages) {
                    Log.v(TAG, String.format(errorMsgPrefix + " Message id = %s, channel = %s", skippedMessage.id, this.name));
                }
                break;
            }
            case presence: {
                this.onPresence(msg, null);
                break;
            }
            case sync: {
                this.onSync(msg);
                break;
            }
            case error: {
                this.setFailed(msg.error);
                break;
            }
            default: {
                Log.e(TAG, "onChannelMessage(): Unexpected message action (" + (Object)((Object)msg.action) + ")");
            }
        }
    }

    void emitUpdate(ErrorInfo errorInfo, boolean resumed) {
        if (this.state == ChannelState.attached) {
            this.emit(ChannelEvent.update, ChannelStateListener.ChannelStateChange.createUpdateEvent(errorInfo, resumed));
        }
    }

    public void emit(ChannelState state, ChannelStateListener.ChannelStateChange channelStateChange) {
        super.emit(state.getChannelEvent(), channelStateChange);
    }

    @Override
    public void on(ChannelState state, ChannelStateListener listener) {
        super.on(state.getChannelEvent(), listener);
    }

    @Override
    public void once(ChannelState state, ChannelStateListener listener) {
        super.once(state.getChannelEvent(), listener);
    }

    private class ChannelStateCompletionListener
    implements ChannelStateListener {
        private CompletionListener completionListener;
        private final ChannelState successState;
        private final ChannelState failureState;

        ChannelStateCompletionListener(CompletionListener completionListener, ChannelState successState, ChannelState failureState) {
            this.completionListener = completionListener;
            this.successState = successState;
            this.failureState = failureState;
        }

        @Override
        public void onChannelStateChanged(ChannelStateListener.ChannelStateChange stateChange) {
            if (stateChange.current.equals((Object)this.successState)) {
                ChannelBase.this.off(this);
                this.completionListener.onSuccess();
            } else if (stateChange.current.equals((Object)this.failureState)) {
                ChannelBase.this.off(this);
                this.completionListener.onError(ChannelBase.this.reason);
            }
        }
    }

    private static class FailedMessage {
        ConnectionManager.QueuedMessage msg;
        ErrorInfo reason;

        FailedMessage(ConnectionManager.QueuedMessage msg, ErrorInfo reason) {
            this.msg = msg;
            this.reason = reason;
        }
    }

    private static class MessageMulticaster
    extends Multicaster<MessageListener>
    implements MessageListener {
        private MessageMulticaster() {
            super(new MessageListener[0]);
        }

        @Override
        public void onMessage(Message message) {
            for (MessageListener member : this.getMembers()) {
                try {
                    member.onMessage(message);
                }
                catch (Throwable t) {
                    Log.e(TAG, "Unexpected exception calling listener", t);
                }
            }
        }
    }

    public static interface MessageListener {
        public void onMessage(Message var1);
    }
}

