/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import io.ably.lib.http.HttpUtils;
import io.ably.lib.push.ActivationContext;
import io.ably.lib.push.ActivationStateMachine;
import io.ably.lib.push.LocalDevice;
import io.ably.lib.push.PushBase;
import io.ably.lib.rest.AblyBase;
import io.ably.lib.rest.AblyRest;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.util.Log;

public class Push
extends PushBase {
    protected ActivationContext activationContext = null;
    private static final String TAG = Push.class.getName();

    public Push(AblyBase rest) {
        super(rest);
    }

    public void activate() throws AblyException {
        this.activate(false);
    }

    public void activate(boolean useCustomRegistrar) throws AblyException {
        Log.v(TAG, "activate(): useCustomRegistrar " + useCustomRegistrar);
        Context context = this.getApplicationContext();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.getStateMachine().handleEvent(ActivationStateMachine.CalledActivate.useCustomRegistrar(useCustomRegistrar, prefs));
    }

    public void deactivate() throws AblyException {
        this.deactivate(false);
    }

    public void deactivate(boolean useCustomRegistrar) throws AblyException {
        Log.v(TAG, "deactivate(): useCustomRegistrar " + useCustomRegistrar);
        Context context = this.getApplicationContext();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.getStateMachine().handleEvent(ActivationStateMachine.CalledDeactivate.useCustomRegistrar(useCustomRegistrar, prefs));
    }

    synchronized ActivationStateMachine getStateMachine() throws AblyException {
        return this.getActivationContext().getActivationStateMachine();
    }

    public void tryRequestRegistrationToken() {
        try {
            if (this.getLocalDevice().isRegistered()) {
                this.getStateMachine().getRegistrationToken();
            }
        }
        catch (AblyException e) {
            Log.e(TAG, "couldn't validate existing push recipient device details", e);
        }
    }

    Context getApplicationContext() throws AblyException {
        Context applicationContext = this.rest.platform.getApplicationContext();
        if (applicationContext == null) {
            Log.e(TAG, "getApplicationContext(): Unable to get application context; not set");
            throw AblyException.fromErrorInfo(new ErrorInfo("Unable to get application context; not set", 40000, 400));
        }
        return applicationContext;
    }

    public ActivationContext getActivationContext() throws AblyException {
        if (this.activationContext == null) {
            Context applicationContext = this.getApplicationContext();
            this.activationContext = ActivationContext.getActivationContext(applicationContext, (AblyRest)this.rest);
        }
        return this.activationContext;
    }

    public LocalDevice getLocalDevice() throws AblyException {
        return this.getActivationContext().getLocalDevice();
    }

    @Override
    Param[] pushRequestHeaders(boolean forLocalDevice) {
        Param[] headers = super.pushRequestHeaders(forLocalDevice);
        if (forLocalDevice) {
            try {
                Param[] deviceIdentityHeaders = this.getLocalDevice().deviceIdentityHeaders();
                if (deviceIdentityHeaders != null) {
                    headers = HttpUtils.mergeHeaders(headers, deviceIdentityHeaders);
                }
            }
            catch (AblyException ablyException) {
                // empty catch block
            }
        }
        return headers;
    }

    @Override
    Param[] pushRequestHeaders(String deviceId) {
        boolean forLocalDevice = false;
        try {
            forLocalDevice = deviceId != null && deviceId.equals(this.getLocalDevice().id);
        }
        catch (AblyException ablyException) {
            // empty catch block
        }
        return this.pushRequestHeaders(forLocalDevice);
    }
}

