/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.platform;

import android.content.Context;
import io.ably.lib.platform.AndroidNetworkConnectivity;
import io.ably.lib.transport.NetworkConnectivity;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;

public class Platform {
    public static final String name = "android";
    private Context applicationContext;
    private final NetworkConnectivity.DelegatedNetworkConnectivity networkConnectivity = new NetworkConnectivity.DelegatedNetworkConnectivity();

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public void setAndroidContext(Context context) throws AblyException {
        context = context.getApplicationContext();
        if (this.applicationContext != null) {
            if (context == this.applicationContext) {
                return;
            }
            throw AblyException.fromErrorInfo(new ErrorInfo("Incompatible application context set", 40000, 400));
        }
        this.applicationContext = context;
        AndroidNetworkConnectivity.getNetworkConnectivity(context).addListener(this.networkConnectivity);
    }

    public boolean hasApplicationContext() {
        return this.applicationContext != null;
    }

    public NetworkConnectivity getNetworkConnectivity() {
        return this.networkConnectivity;
    }
}

