/*
 * Decompiled with CFR 0.152.
 */
package esa.mo.tools.stubgen;

import esa.mo.tools.stubgen.Generator;
import esa.mo.xsd.SpecificationType;
import esa.mo.xsd.util.XmlHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import w3c.xsd.Schema;

public class StubGenerator
extends AbstractMojo {
    protected File xmlDirectory;
    protected File xmlRefDirectory;
    protected File xsdRefDirectory;
    protected File outputDirectory;
    protected String[] targetLanguages;
    protected boolean generateStructures;
    protected boolean generateCOM;
    protected boolean forceGeneration;
    protected Map<String, String> extraProperties;
    protected Map<String, String> packageBindings;
    private static final Map<String, Generator> GENERATOR_MAP = new TreeMap<String, Generator>();
    private static boolean generatorsLoaded = false;

    public static void main(String[] args) {
        StubGenerator gen = new StubGenerator();
        gen.generateStructures = true;
        gen.generateCOM = true;
        gen.extraProperties = new TreeMap<String, String>();
        gen.packageBindings = new TreeMap<String, String>();
        boolean printHelp = false;
        if (0 < args.length) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-h".equalsIgnoreCase(arg)) {
                    printHelp = true;
                    break;
                }
                if ("-?".equalsIgnoreCase(arg)) {
                    printHelp = true;
                    break;
                }
                if ("-l".equalsIgnoreCase(arg)) {
                    List<Map.Entry<String, String>> generators = StubGenerator.getSupportedLanguages((Log)new SystemStreamLog());
                    System.out.println("The following language generators are supported:");
                    for (Map.Entry<String, String> g : generators) {
                        System.out.println(String.format("%8s", g.getKey()) + "  :  " + g.getValue());
                    }
                    return;
                }
                if ("-x".equalsIgnoreCase(arg)) {
                    gen.xmlDirectory = new File(args[++i]);
                    continue;
                }
                if ("-r".equals(arg)) {
                    gen.xmlRefDirectory = new File(args[++i]);
                    continue;
                }
                if ("-R".equals(arg)) {
                    gen.xsdRefDirectory = new File(args[++i]);
                    continue;
                }
                if ("-o".equalsIgnoreCase(arg)) {
                    gen.outputDirectory = new File(args[++i]);
                    continue;
                }
                if (!"-t".equalsIgnoreCase(arg)) continue;
                String targets = args[++i];
                gen.targetLanguages = targets.split(",");
            }
        } else {
            printHelp = true;
        }
        if (printHelp) {
            StubGenerator.printHelp(System.out);
        } else {
            try {
                gen.execute();
            }
            catch (MojoExecutionException ex) {
                System.err.println("ERROR: Exception thrown : " + ex.getMessage());
            }
        }
    }

    public static List<Map.Entry<String, String>> getSupportedLanguages(Log logger) {
        StubGenerator.loadGenerators(logger);
        ArrayList<Map.Entry<String, String>> rv = new ArrayList<Map.Entry<String, String>>(GENERATOR_MAP.size());
        for (Map.Entry<String, Generator> entry : GENERATOR_MAP.entrySet()) {
            Generator g = entry.getValue();
            rv.add(new AbstractMap.SimpleEntry<String, String>(g.getShortName(), g.getDescription()));
        }
        return rv;
    }

    public static StubGenerator createStubGenerator(File xmlDirectory, File xmlRefDirectory, File xsdRefDirectory, File outputDirectory) {
        StubGenerator gen = new StubGenerator();
        gen.setXmlDirectory(xmlDirectory);
        gen.setXmlRefDirectory(xmlRefDirectory);
        gen.setXsdRefDirectory(xsdRefDirectory);
        gen.setOutputDirectory(outputDirectory);
        return gen;
    }

    public void setXmlDirectory(File xmlDirectory) {
        this.xmlDirectory = xmlDirectory;
    }

    public void setXmlRefDirectory(File xmlRefDirectory) {
        this.xmlRefDirectory = xmlRefDirectory;
    }

    public void setXsdRefDirectory(File xsdRefDirectory) {
        this.xsdRefDirectory = xsdRefDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setTargetLanguages(String[] targetLanguages) {
        this.targetLanguages = targetLanguages;
    }

    public void setGenerateStructures(boolean generateStructures) {
        this.generateStructures = generateStructures;
    }

    public void setGenerateCOM(boolean generateCOM) {
        this.generateCOM = generateCOM;
    }

    public void setExtraProperties(Map<String, String> extraProperties) {
        this.extraProperties = extraProperties;
    }

    public void setPackageBindings(Map<String, String> packageBindings) {
        this.packageBindings = packageBindings;
    }

    public void execute() throws MojoExecutionException {
        StubGenerator.loadGenerators(this.getLog());
        if (null == this.extraProperties) {
            this.extraProperties = new TreeMap<String, String>();
        }
        if (this.xmlDirectory.exists()) {
            String steps = "Step 0.. ";
            try {
                List refSpecs = XmlHelper.loadSpecifications((File)this.xmlRefDirectory);
                steps = steps + "Step 1.. ";
                List<Map.Entry<Schema, XmlHelper.XmlSpecification>> refXsd = StubGenerator.loadXsdSpecifications(this.xsdRefDirectory);
                steps = steps + "Step 2.. ";
                List specs = XmlHelper.loadSpecifications((File)this.xmlDirectory);
                steps = steps + "Step 3.. ";
                long inputTimestamp = this.getLatestTimestamp(0L, refSpecs);
                inputTimestamp = this.getLatestSchemaTimestamp(inputTimestamp, refXsd);
                inputTimestamp = this.getLatestTimestamp(inputTimestamp, specs);
                if (null != this.targetLanguages && 0 < this.targetLanguages.length) {
                    if (this.forceGeneration || this.outputDirectory.lastModified() < inputTimestamp) {
                        if (this.forceGeneration) {
                            this.getLog().info((CharSequence)"Generation being forced");
                        }
                        for (String targetLanguage : this.targetLanguages) {
                            Generator gen = GENERATOR_MAP.get(targetLanguage.toLowerCase());
                            if (null != gen) {
                                this.processWithGenerator(gen, refSpecs, refXsd, specs);
                                continue;
                            }
                            this.getLog().warn((CharSequence)("Could not find generator for language: " + targetLanguage));
                        }
                        this.outputDirectory.setLastModified(System.currentTimeMillis());
                    }
                    this.getLog().info((CharSequence)"No change in input files detected, generation skipped");
                }
                this.getLog().error((CharSequence)"No generators selected - could not process files");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("(a) Exception thrown during the processing of XML file: ", (Exception)ex);
            }
            catch (JAXBException ex) {
                ex.printStackTrace();
                throw new MojoExecutionException(steps + " (b) Exception thrown during the processing of XML file: ", (Exception)((Object)ex));
            }
        } else {
            this.getLog().error((CharSequence)"XML directory is not valid");
        }
    }

    private static void printHelp(PrintStream out) {
        out.println("Usage: stub-generator [-options]");
        out.println("");
        out.println("where options include:");
        out.println("    -x <directory containing the XML service specification>");
        out.println("                  Specify the location of the XML specifications to process");
        out.println("    -r <directory containing the reference XML service specification>");
        out.println("                  Specify the location of the XML specifications to process");
        out.println("                  that are referenced but do not require any generation");
        out.println("    -o <output directory>");
        out.println("                  Specify the location of the output directory");
        out.println("    -t <target languages to generate>");
        out.println("                  A , separated list of language generators");
        out.println("    -l");
        out.println("                  Lists supported language generators");
        out.println("    -? -h         Print this help message");
    }

    private static List<Map.Entry<Schema, XmlHelper.XmlSpecification>> loadXsdSpecifications(File directory) throws IOException, JAXBException {
        LinkedList<Map.Entry<Schema, XmlHelper.XmlSpecification>> specList = new LinkedList<Map.Entry<Schema, XmlHelper.XmlSpecification>>();
        if (directory.exists()) {
            File[] xmlFiles;
            for (File file : xmlFiles = directory.listFiles()) {
                if (!file.isFile()) continue;
                specList.add(StubGenerator.loadXsdSpecification(file));
            }
        }
        return specList;
    }

    private static AbstractMap.SimpleEntry<Schema, XmlHelper.XmlSpecification> loadXsdSpecification(File is) throws IOException, JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"w3c.xsd");
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return new AbstractMap.SimpleEntry<Schema, XmlHelper.XmlSpecification>((Schema)unmarshaller.unmarshal(is), new XmlHelper.XmlSpecification(is, null));
    }

    private static void loadGenerators(Log logger) {
        if (!generatorsLoaded) {
            generatorsLoaded = true;
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forClassLoader()).setScanners(new Scanner[]{new SubTypesScanner()}));
            Set classes = reflections.getSubTypesOf(Generator.class);
            for (Class cls : classes) {
                int mods = cls.getModifiers();
                if (Modifier.isAbstract(mods)) continue;
                try {
                    Generator g = (Generator)cls.getConstructor(Log.class).newInstance(logger);
                    GENERATOR_MAP.put(g.getShortName().toLowerCase(), g);
                }
                catch (Exception ex) {
                    logger.warn((CharSequence)("Could not construct generator : " + cls.getName()));
                }
            }
        }
    }

    private void processWithGenerator(Generator generator, List<Map.Entry<SpecificationType, XmlHelper.XmlSpecification>> refSpecs, List<Map.Entry<Schema, XmlHelper.XmlSpecification>> refXsd, List<Map.Entry<SpecificationType, XmlHelper.XmlSpecification>> specs) throws MojoExecutionException {
        try {
            generator.reset();
            generator.init(this.outputDirectory.getPath(), this.generateStructures, this.generateCOM, this.packageBindings, this.extraProperties);
            generator.postinit(this.outputDirectory.getPath(), this.generateStructures, this.generateCOM, this.packageBindings, this.extraProperties);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Exception thrown during the opening of the generator", (Exception)ex);
        }
        for (Map.Entry<SpecificationType, XmlHelper.XmlSpecification> entry : refSpecs) {
            try {
                generator.preProcess(entry.getKey());
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Exception thrown during the pre-processing of reference XML file: " + entry.getValue().file.getPath(), ex);
            }
        }
        for (Map.Entry<SpecificationType, XmlHelper.XmlSpecification> entry : refXsd) {
            try {
                generator.preProcess((Schema)entry.getKey());
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Exception thrown during the pre-processing of reference XSD file: " + entry.getValue().file.getPath(), ex);
            }
        }
        for (Map.Entry<SpecificationType, XmlHelper.XmlSpecification> entry : specs) {
            try {
                generator.preProcess(entry.getKey());
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Exception thrown during the pre-processing of XML file: " + entry.getValue().file.getPath(), ex);
            }
        }
        for (Map.Entry<SpecificationType, XmlHelper.XmlSpecification> entry : specs) {
            try {
                this.getLog().info((CharSequence)("Generating " + generator.getShortName()));
                generator.compile(this.outputDirectory.getPath(), entry.getKey(), entry.getValue().rootElement);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("(c) Exception thrown during the processing of XML file: " + entry.getValue().file.getPath(), ex);
            }
        }
        try {
            generator.close(this.outputDirectory.getPath());
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Exception thrown during the closing of the generator", (Exception)ex);
        }
    }

    private long getLatestTimestamp(long inputTimestamp, List<Map.Entry<SpecificationType, XmlHelper.XmlSpecification>> specs) {
        for (Map.Entry<SpecificationType, XmlHelper.XmlSpecification> spec : specs) {
            long fileTimestamp = spec.getValue().file.lastModified();
            if (fileTimestamp <= inputTimestamp) continue;
            inputTimestamp = fileTimestamp;
        }
        return inputTimestamp;
    }

    private long getLatestSchemaTimestamp(long inputTimestamp, List<Map.Entry<Schema, XmlHelper.XmlSpecification>> specs) {
        for (Map.Entry<Schema, XmlHelper.XmlSpecification> spec : specs) {
            long fileTimestamp = spec.getValue().file.lastModified();
            if (fileTimestamp <= inputTimestamp) continue;
            inputTimestamp = fileTimestamp;
        }
        return inputTimestamp;
    }
}

