/*
 * Decompiled with CFR 0.152.
 */
package info.vividcode.android.cra;

import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import info.vividcode.android.cra.ViewHolderFactory;
import info.vividcode.android.cra.ViewType;

public class ViewHolderFactoryRegistry {
    private int viewTypeCounter = 1;
    private final SparseArray<ViewHolderFactory<?>> mViewTypeToFactoryMap = new SparseArray();

    public synchronized <VH extends RecyclerView.ViewHolder> ViewType<VH> register(ViewHolderFactory<VH> factory) {
        if (factory == null) {
            throw new NullPointerException("Factory to be registered cannot be null.");
        }
        int viewType = this.viewTypeCounter++;
        this.mViewTypeToFactoryMap.put(viewType, factory);
        return new ViewType(viewType);
    }

    public synchronized ViewHolderFactory<?> getFactory(int viewType) {
        ViewHolderFactory factory = (ViewHolderFactory)this.mViewTypeToFactoryMap.get(viewType);
        if (factory != null) {
            return factory;
        }
        throw new IllegalArgumentException("Not registered view type: " + viewType);
    }
}

