/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.models.web.security;

import info.setmy.models.VariableValue;
import info.setmy.models.web.security.PolicyDirective;
import java.util.ArrayList;
import java.util.Optional;

public class ContentSecurityPolicy
extends ArrayList<PolicyDirective> {
    public static final String NAME = "Content-Security-Policy";

    public VariableValue getVariableValue() {
        return new VariableValue(NAME, this.toString());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String add = null;
        for (PolicyDirective policy : this) {
            if (policy.isEmpty()) continue;
            if (add == null) {
                add = "; ";
            } else {
                stringBuilder.append(add);
            }
            stringBuilder.append(policy.toString());
        }
        return stringBuilder.toString();
    }

    public PolicyDirective newPolicyDirective(String name) {
        Optional<PolicyDirective> optionalPolicyDirective = this.addPolicyDirective(new PolicyDirective(name));
        return optionalPolicyDirective.get();
    }

    public Optional<PolicyDirective> addPolicyDirective(PolicyDirective policyDirective) {
        Optional<PolicyDirective> optional = Optional.of(policyDirective);
        boolean addResult = this.add(optional.get());
        if (addResult) {
            return optional;
        }
        return Optional.empty();
    }

    public Optional<PolicyDirective> getByDirectiveName(String directiveName) {
        return this.stream().filter(directive -> directive.getName().equalsIgnoreCase(directiveName)).findFirst();
    }
}

