/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.models.web.security;

import info.setmy.models.VariableValues;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;

public class PolicyDirective
extends VariableValues {
    public PolicyDirective() {
        super(null);
    }

    public PolicyDirective(String name) {
        super(name);
    }

    public String toString() {
        if (this.getObjectOptional().isPresent() && ((List)this.getObjectOptional().get()).isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName()).append(" ");
        boolean add = false;
        for (String value : (List)this.getObject()) {
            if (add) {
                stringBuilder.append(" ");
            } else {
                add = true;
            }
            stringBuilder.append(value);
        }
        return stringBuilder.toString();
    }

    public PolicyDirective addSHA256(String sha256) {
        return this.addSHA("sha256", sha256);
    }

    public PolicyDirective addSHA384(String sha384) {
        return this.addSHA("sha384", sha384);
    }

    public PolicyDirective addSHA512(String sha512) {
        return this.addSHA("sha512", sha512);
    }

    private PolicyDirective addSHA(String hashType, String has) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] encoded = encoder.encode(has.getBytes("utf-8"));
            stringBuilder.append("'");
            stringBuilder.append(hashType);
            stringBuilder.append("-");
            stringBuilder.append(new String(encoded));
            stringBuilder.append("'");
            return this.add(stringBuilder.toString());
        }
        catch (UnsupportedEncodingException ex) {
            return this;
        }
    }

    public PolicyDirective addNonce(String nonceValue) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'nonce-");
        stringBuilder.append(nonceValue);
        stringBuilder.append("'");
        this.add(stringBuilder.toString());
        return this;
    }

    public PolicyDirective add(String value) {
        ((List)this.getObject()).add(value);
        return this;
    }

    public PolicyDirective add(String[] array) {
        return this.add(Arrays.asList(array));
    }

    public PolicyDirective add(List<String> aList) {
        ((List)this.getObject()).addAll(aList);
        return this;
    }

    public boolean isEmpty() {
        Optional objectOptional = this.getObjectOptional();
        if (objectOptional.isPresent()) {
            return ((List)objectOptional.get()).isEmpty();
        }
        return true;
    }

    public class DirectiveSourceNames {
        public static final String SELF = "'self'";
        public static final String UNSAFE_INLINE = "'unsafe-inline'";
        public static final String UNSAFE_EVAL = "'unsafe-eval'";
        public static final String NONE = "'none'";
    }

    public class DirectiveNames {
        public static final String CONNECT_SRC = "connect-src";
        public static final String DEFAULT_SRC = "default-src";
        public static final String FONT_SRC = "font-src";
        public static final String FRAME_SRC = "frame-src";
        public static final String IMG_SRC = "img-src";
        public static final String MANIFEST_SRC = "manifest-src";
        public static final String MEDIA_SRC = "media-src";
        public static final String OBJECT_SRC = "object-src";
        public static final String SCRIPT_SRC = "script-src";
        public static final String STYLE_SRC = "style-src";
        public static final String WORKER_SRC = "worker-src";
        public static final String BASE_URI = "base-uri";
        public static final String PLUGIN_TYPES = "plugin-types";
        public static final String SANDBOX = "sandbox";
        public static final String FORM_ACTION = "form-action";
        public static final String FRAME_ANCESTORS = "frame-ancestors";
        public static final String BLOCK_ALL_MIXED_CONTENT = "block-all-mixed-content";
        public static final String REQUIRE_SRI_FOR = "require-sri-for";
        public static final String UPGRADE_INSECURE_REQUESTS = "upgrade-insecure-requests";
    }
}

