/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojos.utilities;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenUtils {
    private static final String WINDOWS_OS = "windows";
    private static final String MAC_OS = "mac os x";
    private static final String MAC_OS_DARWIN = "darwin";
    private static final String LINUX_OS = "linux";

    private MavenUtils() {
    }

    public static File resolveSourceFile(MavenProject project, String sourceFile) {
        File sourceDirectory = new File(project.getBuild().getSourceDirectory());
        if (sourceFile != null) {
            return new File(sourceDirectory, sourceFile);
        }
        File[] files = sourceDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && (pathname.getName().endsWith(".mxml") || pathname.getName().endsWith(".as"));
            }
        });
        if (files.length == 1) {
            return files[0];
        }
        if (files.length > 1) {
            for (File file : files) {
                if (!file.getName().equalsIgnoreCase("Main.mxml") && !file.getName().equalsIgnoreCase("Main.as")) continue;
                return file;
            }
            for (File file : files) {
                if (!file.getName().equalsIgnoreCase("Index.mxml") && !file.getName().equalsIgnoreCase("Index.as")) continue;
                return file;
            }
        }
        return null;
    }

    public static Set<Artifact> getDependencyArtifacts(MavenProject project, ArtifactResolver resolver, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource artifactMetadataSource) throws MojoExecutionException {
        ArtifactResolutionResult arr;
        try {
            arr = resolver.resolveTransitively(project.getDependencyArtifacts(), project.getArtifact(), remoteRepositories, localRepository, artifactMetadataSource);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Set result = arr.getArtifacts();
        return result;
    }

    public static File getArtifactFile(Artifact a, String scope, Build build) throws MojoExecutionException {
        if (a.getGroupId().equals("com.adobe.flex.sdk") && a.getArtifactId().equals("playerglobal")) {
            File dest = new File(build.getOutputDirectory(), "libraries/" + scope + "/" + a.getArtifactId() + ".swc");
            if (!dest.exists()) {
                try {
                    FileUtils.copyFile((File)a.getFile(), (File)dest);
                    dest.deleteOnExit();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            return dest;
        }
        return a.getFile();
    }

    public static void resolveArtifact(Artifact artifact, ArtifactResolver resolver, ArtifactRepository localRepository, List remoteRepositories) throws MojoExecutionException {
        try {
            resolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static File[] getSourcePaths(Build build) {
        return MavenUtils.getFiles(build.getSourceDirectory(), build.getResources());
    }

    public static File[] getTestSourcePaths(Build build) {
        return MavenUtils.getFiles(build.getTestSourceDirectory(), build.getTestResources());
    }

    private static File[] getFiles(String sourceDirectory, List<Resource> resources) {
        ArrayList<File> files = new ArrayList<File>();
        File source = new File(sourceDirectory);
        if (source.exists()) {
            files.add(source);
        }
        for (Resource resource : resources) {
            File resourceFile = new File(resource.getDirectory());
            if (!resourceFile.exists()) continue;
            files.add(resourceFile);
        }
        return files.toArray(new File[files.size()]);
    }

    public static File getConfigFile(Build build) throws MojoExecutionException {
        URL url = MavenUtils.class.getResource("/configs/config.xml");
        File configFile = new File(build.getOutputDirectory(), "config.xml");
        try {
            FileUtils.copyURLToFile((URL)url, (File)configFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating config file.", (Exception)e);
        }
        return configFile;
    }

    public static File getFontsFile(Build build) throws MojoExecutionException {
        URL url = MavenUtils.isMac() ? MavenUtils.class.getResource("/fonts/macFonts.ser") : MavenUtils.class.getResource("/fonts/winFonts.ser");
        File fontsSer = new File(build.getOutputDirectory(), "fonts.ser");
        try {
            FileUtils.copyURLToFile((URL)url, (File)fontsSer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying fonts file.", (Exception)e);
        }
        return fontsSer;
    }

    public static File getLocaleResourcePath(String resourceBundlePath, String locale) throws MojoExecutionException {
        String path = resourceBundlePath.replace("{locale}", locale);
        File localePath = new File(path);
        if (!localePath.exists()) {
            throw new MojoExecutionException("Unable to find locales path: " + path);
        }
        return localePath;
    }

    public static String getCompilerPluginSetting(MavenProject project, String optionName) {
        String value = MavenUtils.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPlugins(), optionName);
        if (value == null && project.getModel().getBuild().getPluginManagement() != null) {
            value = MavenUtils.findCompilerPluginSettingInPlugins(project.getModel().getBuild().getPluginManagement().getPlugins(), optionName);
        }
        return value;
    }

    private static String findCompilerPluginSettingInPlugins(List<Plugin> plugins, String optionName) {
        String value = null;
        for (Plugin plugin : plugins) {
            if (!plugin.getArtifactId().equals("flex-compiler-mojo")) continue;
            Xpp3Dom o = (Xpp3Dom)plugin.getConfiguration();
            if (o != null && o.getChild(optionName) != null) {
                value = o.getChild(optionName).getValue();
            }
            List executions = plugin.getExecutions();
            for (PluginExecution execution : executions) {
                o = (Xpp3Dom)execution.getConfiguration();
                if (o == null || o.getChild(optionName) == null) continue;
                value = o.getChild(optionName).getValue();
            }
        }
        return value;
    }

    public static String osString() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindows() {
        return MavenUtils.osString().startsWith(WINDOWS_OS);
    }

    public static boolean isLinux() {
        return MavenUtils.osString().startsWith(LINUX_OS);
    }

    public static boolean isMac() {
        return MavenUtils.osString().startsWith(MAC_OS) || MavenUtils.osString().startsWith(MAC_OS_DARWIN);
    }
}

