/*
 * Decompiled with CFR 0.152.
 */
package info.flexmojos.generator;

import info.flexmojos.generator.FlexmojosAs3Controller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.granite.generator.GenerationController;
import org.granite.generator.GenerationListener;
import org.granite.generator.Generator;
import org.granite.generator.as3.As3TypeFactory;
import org.granite.generator.as3.DefaultAs3TypeFactory;
import org.granite.generator.as3.JavaFileGenerationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorMojo
extends AbstractMojo {
    protected MavenProject project;
    private String[] includeClasses;
    private String[] excludeClasses;
    protected Build build;
    private String style;
    private File outputDirectory;
    private String uid = "uid";
    private String[] entityTemplate;
    private String[] interfaceTemplate;
    private String[] beanTemplate;
    private String[] enumTemplate;

    public void execute() throws MojoExecutionException {
        URLClassLoader loader;
        List<String> classes;
        this.setUp();
        List<File> jarDependencies = this.getJarDependencies();
        if (jarDependencies.isEmpty()) {
            this.getLog().warn((CharSequence)"No jar dependencies found.");
            return;
        }
        try {
            classes = this.getClasses(jarDependencies);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error on classes resolve", (Exception)e);
        }
        try {
            loader = URLClassLoader.newInstance(this.getUrls(jarDependencies));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to get dependency URL", (Exception)e);
        }
        Generator<Class<?>, JavaFileGenerationUnit> generator = this.getGenerator();
        int count = 0;
        for (String className : classes) {
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(className);
                count += generator.generate(clazz);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Could not generate AS3 beans for: '" + clazz + "'"), (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)(count + " files generated."));
    }

    private URL[] getUrls(List<File> jarDependencies) throws MalformedURLException {
        URL[] urls = new URL[jarDependencies.size()];
        for (int i = 0; i < jarDependencies.size(); ++i) {
            urls[i] = jarDependencies.get(i).toURL();
        }
        return urls;
    }

    private List<File> getJarDependencies() {
        ArrayList<File> jarDependencies = new ArrayList<File>();
        Set artifacts = this.project.getDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"jar".equals(artifact.getType())) continue;
            File file = artifact.getFile();
            if (file != null && file.exists()) {
                jarDependencies.add(file);
                continue;
            }
            this.getLog().warn((CharSequence)("Dependency file not found: " + artifact));
        }
        return jarDependencies;
    }

    private Generator<Class<?>, JavaFileGenerationUnit> getGenerator() {
        DefaultAs3TypeFactory as3TypeFactory = new DefaultAs3TypeFactory();
        FlexmojosAs3Controller controller = new FlexmojosAs3Controller((As3TypeFactory)as3TypeFactory);
        controller.setStyle(this.style);
        controller.setBeanTemplateUris(this.beanTemplate);
        controller.setEntityTemplateUris(this.entityTemplate);
        controller.setEnumTemplateUris(this.enumTemplate);
        controller.setInterfaceTemplateUris(this.interfaceTemplate);
        controller.setOutputDirectory(this.outputDirectory);
        controller.setUid(this.uid);
        GenerationListener<JavaFileGenerationUnit> listener = new GenerationListener<JavaFileGenerationUnit>(){

            public void generating(JavaFileGenerationUnit unit) {
                GeneratorMojo.this.getLog().info((CharSequence)("  Generating: " + unit.getOutput()));
            }
        };
        Generator generator = new Generator((GenerationController)controller, (GenerationListener)listener);
        return generator;
    }

    private List<String> getClasses(List<File> jarDependencies) throws IOException {
        ArrayList<String> classes = new ArrayList<String>();
        for (File file : jarDependencies) {
            JarEntry jarEntry;
            JarInputStream jar = new JarInputStream(new FileInputStream(file));
            while ((jarEntry = jar.getNextJarEntry()) != null) {
                String className = jarEntry.getName();
                if (jarEntry.isDirectory() || !className.endsWith(".class")) continue;
                className = className.replace('/', '.');
                if (!this.matchWildCard(className = className.substring(0, className.length() - 6), this.includeClasses) || this.matchWildCard(className, this.excludeClasses)) continue;
                classes.add(className);
            }
        }
        return classes;
    }

    private boolean matchWildCard(String className, String[] wildCards) {
        if (wildCards == null) {
            return false;
        }
        int i$ = 0;
        String[] arr$ = wildCards;
        int len$ = arr$.length;
        if (i$ < len$) {
            String wildCard = arr$[i$];
            return FilenameUtils.wildcardMatch((String)className, (String)wildCard);
        }
        return false;
    }

    private void setUp() throws MojoExecutionException {
        if (this.includeClasses == null) {
            this.includeClasses = new String[]{"*.class"};
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }
}

