/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.mojo.flexmojo.compiler;

import flex2.tools.Compiler;
import flex2.tools.oem.Application;
import flex2.tools.oem.Logger;
import info.rvin.flexmojos.utilities.MavenUtils;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo;
import info.rvin.mojo.flexmojo.compiler.CompileLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMojo
extends AbstractFlexCompilerMojo<Application> {
    protected String sourceFile;
    private String[] moduleFiles;
    private List<File> modules;
    private boolean loadExternsOnModules;
    protected File source;

    @Override
    public void setUp() throws MojoExecutionException, MojoFailureException {
        File sourceDirectory = new File(this.build.getSourceDirectory());
        if (!sourceDirectory.exists()) {
            throw new MojoExecutionException("Unable to found sourceDirectory: " + sourceDirectory);
        }
        if (this.source == null) {
            this.source = MavenUtils.resolveSourceFile((MavenProject)this.project, (String)this.sourceFile);
        }
        if (this.source == null) {
            throw new MojoExecutionException("Source file not expecified and no default found!");
        }
        if (!this.source.exists()) {
            throw new MojoFailureException("Unable to find " + this.sourceFile);
        }
        try {
            this.builder = new Application(this.source);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("Unable to find " + this.source);
        }
        if (this.moduleFiles != null) {
            this.modules = new ArrayList<File>();
            for (String modulePath : this.moduleFiles) {
                File module = new File(sourceDirectory, modulePath);
                if (!module.exists()) {
                    throw new MojoExecutionException("Module " + module + " not found.");
                }
                this.modules.add(module);
            }
            if (this.loadExternsOnModules) {
                this.linkReport = true;
            }
        }
        super.setUp();
        ((Application)this.builder).setOutput(this.outputFile);
    }

    @Override
    protected void tearDown() throws MojoExecutionException, MojoFailureException {
        super.tearDown();
        if (this.modules != null) {
            this.configuration.addExterns(new File[]{this.linkReportFile});
            for (File module : this.modules) {
                Application moduleBuilder;
                this.getLog().info((CharSequence)("Compiling module " + module));
                String moduleName = module.getName();
                moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
                try {
                    moduleBuilder = new Application(module);
                }
                catch (FileNotFoundException e) {
                    throw new MojoFailureException("Unable to find " + module);
                }
                moduleBuilder.setConfiguration(this.configuration);
                moduleBuilder.setLogger((Logger)new CompileLogger(this.getLog()));
                File outputModule = new File(this.build.getDirectory(), this.build.getFinalName() + "-" + moduleName + "." + this.project.getPackaging());
                moduleBuilder.setOutput(outputModule);
                this.build(moduleBuilder);
                this.projectHelper.attachArtifact(this.project, "swf", moduleName, outputModule);
            }
        }
    }

    @Override
    protected void writeResourceBundle(String[] bundles, String locale, File localePath) throws MojoExecutionException {
        File output = new File(this.build.getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + locale + ".swf");
        String bundlesString = Arrays.toString(bundles).replace("[", "").replace("]", "").replace(", ", ",");
        ArrayList<File> external = new ArrayList<File>();
        ArrayList<File> internal = new ArrayList<File>();
        ArrayList<File> merged = new ArrayList<File>();
        external.addAll(Arrays.asList(this.getDependenciesPath("external")));
        external.addAll(Arrays.asList(this.getDependenciesPath("rsl")));
        internal.addAll(Arrays.asList(this.getDependenciesPath("internal")));
        merged.addAll(Arrays.asList(this.getDependenciesPath("compile")));
        merged.addAll(Arrays.asList(this.getDependenciesPath("merged")));
        merged.addAll(Arrays.asList(this.getResourcesBundles()));
        HashSet<String> args = new HashSet<String>();
        args.add("-locale=" + locale);
        args.add("-source-path=" + localePath.getAbsolutePath());
        args.add("-include-resource-bundles=" + bundlesString);
        args.add("-output=" + output.getAbsolutePath());
        args.add("-compiler.fonts.local-fonts-snapshot=" + this.getFontsSnapshot().getAbsolutePath());
        args.add("-load-config=" + this.configFile.getAbsolutePath());
        args.add("-external-library-path=" + this.toString(external));
        args.add("-include-libraries=" + this.toString(internal));
        args.add("-library-path=" + this.toString(merged));
        Compiler.mxmlc((String[])args.toArray(new String[args.size()]));
        this.projectHelper.attachArtifact(this.project, "swf", locale, output);
    }

    private String toString(List<File> libs) {
        StringBuilder sb = new StringBuilder();
        for (File lib : libs) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(lib.getAbsolutePath());
        }
        return sb.toString();
    }
}

