/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.mojo.flexmojo;

import info.rvin.flexmojos.utilities.MavenUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIrvinMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Build build;
    protected MavenProjectHelper projectHelper;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver resolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;
    private Set<Artifact> dependencyArtifacts;

    protected Set<Artifact> getDependencyArtifacts() throws MojoExecutionException {
        if (this.dependencyArtifacts == null) {
            this.dependencyArtifacts = MavenUtils.getDependencyArtifacts((MavenProject)this.project, (ArtifactResolver)this.resolver, (ArtifactRepository)this.localRepository, (List)this.remoteRepositories, (ArtifactMetadataSource)this.artifactMetadataSource);
        }
        return this.dependencyArtifacts;
    }

    protected List<Artifact> getDependencyArtifacts(String ... scopes) throws MojoExecutionException {
        if (scopes == null) {
            return null;
        }
        if (scopes.length == 0) {
            return new ArrayList<Artifact>();
        }
        List<String> scopesList = Arrays.asList(scopes);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact artifact : this.getDependencyArtifacts()) {
            if (!"swc".equals(artifact.getType()) || !scopesList.contains(artifact.getScope())) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setUp();
        this.run();
        this.tearDown();
    }

    protected abstract void setUp() throws MojoExecutionException, MojoFailureException;

    protected abstract void run() throws MojoExecutionException, MojoFailureException;

    protected abstract void tearDown() throws MojoExecutionException, MojoFailureException;
}

