/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojos.encrypter;

import info.rvin.flexmojos.encrypter.encryptations.AesEncrypter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncrypterMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    private String key;
    private String iv;

    private List<Artifact> getGeneratedSwf() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        List attachedArtifacts = this.project.getAttachedArtifacts();
        for (Artifact artifact : attachedArtifacts) {
            if (!"swf".equals(artifact.getType())) continue;
            artifacts.add(artifact);
        }
        if ("swf".equals(this.project.getArtifact().getType())) {
            artifacts.add(this.project.getArtifact());
        }
        return artifacts;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Artifact> artifacts = this.getGeneratedSwf();
        for (Artifact artifact : artifacts) {
            this.getLog().info((CharSequence)("Encrypting artifact " + artifact));
            File enc = this.getDestinationFile(this.project.getBuild(), artifact);
            this.getLog().debug((CharSequence)("Encrypted file: " + enc));
            this.encrypt(artifact, enc);
            this.projectHelper.attachArtifact(this.project, "eswf", artifact.getClassifier(), enc);
        }
    }

    private File getDestinationFile(Build build, Artifact artifact) {
        String fileName = this.project.getBuild().getFinalName();
        if (artifact.getClassifier() != null) {
            fileName = fileName + "-" + artifact.getClassifier();
        }
        fileName = fileName + ".eswf";
        return new File(this.project.getBuild().getDirectory(), fileName);
    }

    private void encrypt(Artifact artifact, File enc) throws MojoExecutionException {
        try {
            AesEncrypter.encrypt(this.key, this.iv, artifact.getFile(), enc);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to encrypt artifact " + artifact, (Exception)e);
        }
    }
}

