/*
 * Decompiled with CFR 0.152.
 */
package com.ai.android.picker;

import android.content.Context;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextSwitcher;
import com.ai.android.picker.NumberPicker;
import com.ai.android.picker.R;
import java.util.Calendar;

public class TimePicker
extends FrameLayout
implements View.OnClickListener {
    private Context mContext;
    private NumberPicker hourPicker;
    private NumberPicker minPicker;
    private TextSwitcher timeSwitcher;
    private Calendar mCalendar;
    boolean is24Hour;
    boolean isAm = true;

    public TimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mCalendar = Calendar.getInstance();
        ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(R.layout.time_picker, (ViewGroup)this, true);
        this.hourPicker = (NumberPicker)this.findViewById(R.id.time_hours);
        this.minPicker = (NumberPicker)this.findViewById(R.id.time_minutes);
        this.timeSwitcher = (TextSwitcher)this.findViewById(R.id.time_switcher);
        this.minPicker.setMinValue(0);
        this.minPicker.setMaxValue(59);
        this.minPicker.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.hourPicker.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.is24Hour = DateFormat.is24HourFormat((Context)context);
        this.timeSwitcher.setOnClickListener((View.OnClickListener)this);
        this.minPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                TimePicker.this.mCalendar.set(12, newVal);
            }
        });
        this.hourPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                TimePicker.this.mCalendar.set(10, newVal);
            }
        });
        this.updateTime();
    }

    public TimePicker(Context context) {
        this(context, null);
    }

    private void updateTime() {
        System.out.println(this.mCalendar.getTime());
        if (this.is24Hour) {
            this.hourPicker.setMinValue(0);
            this.hourPicker.setMaxValue(23);
            this.hourPicker.setValue(this.mCalendar.get(11));
            this.timeSwitcher.setVisibility(8);
        } else {
            this.hourPicker.setMinValue(1);
            this.hourPicker.setMaxValue(12);
            this.hourPicker.setValue(this.mCalendar.get(10));
            if (this.mCalendar.get(9) == 1) {
                this.isAm = false;
                this.timeSwitcher.setText((CharSequence)"pm");
            } else {
                this.isAm = true;
                this.timeSwitcher.setText((CharSequence)"am");
            }
            this.timeSwitcher.setVisibility(0);
        }
        this.minPicker.setValue(this.mCalendar.get(12));
    }

    public boolean isIs24Hour() {
        return this.is24Hour;
    }

    public void setIs24Hour(boolean is24Hour) {
        this.is24Hour = is24Hour;
        this.updateTime();
    }

    public String getTime() {
        String time = "";
        time = this.is24Hour ? this.hourPicker.getValue() + ":" + this.minPicker.getValue() : this.hourPicker.getValue() + ":" + this.minPicker.getValue() + " " + (this.isAm ? "am" : "pm");
        return time;
    }

    public int getHourOfDay() {
        return this.is24Hour || this.isAm ? this.hourPicker.getValue() : (this.hourPicker.getValue() + 12) % 24;
    }

    public int getHour() {
        return this.hourPicker.getValue();
    }

    public int getMinute() {
        return this.mCalendar.get(12);
    }

    public void setCalendar(Calendar calendar) {
        this.mCalendar.set(11, calendar.get(11));
        this.mCalendar.set(12, calendar.get(12));
        this.updateTime();
    }

    public void onClick(View v) {
        boolean bl = this.isAm = !this.isAm;
        if (this.isAm) {
            this.mCalendar.roll(10, -12);
            this.timeSwitcher.setText((CharSequence)"am");
        } else {
            this.mCalendar.roll(10, 12);
            this.timeSwitcher.setText((CharSequence)"pm");
        }
    }
}

