/*
 * Decompiled with CFR 0.152.
 */
package com.ai.android.picker;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.ai.android.picker.NumberPicker;
import com.ai.android.picker.R;
import java.util.Calendar;

public class DatePicker
extends FrameLayout {
    private Context mContext;
    private NumberPicker mDayPicker;
    private NumberPicker mMonthPicker;
    private NumberPicker mYearPicker;
    private Calendar mCalendar;
    private String[] mMonthDisplay;

    public DatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mCalendar = Calendar.getInstance();
        this.initMonthDisplay();
        ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(R.layout.date_picker, (ViewGroup)this, true);
        this.mDayPicker = (NumberPicker)this.findViewById(R.id.date_day);
        this.mMonthPicker = (NumberPicker)this.findViewById(R.id.date_month);
        this.mYearPicker = (NumberPicker)this.findViewById(R.id.date_year);
        this.mDayPicker.setMinValue(1);
        this.mDayPicker.setMaxValue(31);
        this.mDayPicker.setValue(20);
        this.mDayPicker.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.mMonthPicker.setMinValue(0);
        this.mMonthPicker.setMaxValue(11);
        this.mMonthPicker.setDisplayedValues(this.mMonthDisplay);
        this.mMonthPicker.setValue(this.mCalendar.get(2));
        this.mYearPicker.setMinValue(1950);
        this.mYearPicker.setMaxValue(2100);
        this.mYearPicker.setValue(this.mCalendar.get(1));
        this.mMonthPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mCalendar.set(2, newVal);
                DatePicker.this.updateDate();
            }
        });
        this.mDayPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mCalendar.set(5, newVal);
                DatePicker.this.updateDate();
            }
        });
        this.mYearPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                DatePicker.this.mCalendar.set(1, newVal);
                DatePicker.this.updateDate();
            }
        });
        this.updateDate();
    }

    private void initMonthDisplay() {
        this.mMonthDisplay = new String[12];
        this.mMonthDisplay[0] = "Jan";
        this.mMonthDisplay[1] = "Feb";
        this.mMonthDisplay[2] = "Mar";
        this.mMonthDisplay[3] = "Apr";
        this.mMonthDisplay[4] = "May";
        this.mMonthDisplay[5] = "Jun";
        this.mMonthDisplay[6] = "Jul";
        this.mMonthDisplay[7] = "Aug";
        this.mMonthDisplay[8] = "Sep";
        this.mMonthDisplay[9] = "Oct";
        this.mMonthDisplay[10] = "Nov";
        this.mMonthDisplay[11] = "Dec";
    }

    private void updateDate() {
        System.out.println("Month: " + this.mCalendar.get(2) + " Max: " + this.mCalendar.getActualMaximum(5));
        this.mDayPicker.setMinValue(this.mCalendar.getActualMinimum(5));
        this.mDayPicker.setMaxValue(this.mCalendar.getActualMaximum(5));
        this.mDayPicker.setValue(this.mCalendar.get(5));
        this.mMonthPicker.setValue(this.mCalendar.get(2));
        this.mYearPicker.setValue(this.mCalendar.get(1));
    }

    public DatePicker(Context context) {
        this(context, null);
    }

    public String getDate() {
        String date = this.mYearPicker.getValue() + "-" + (this.mMonthPicker.getValue() + 1) + "-" + this.mDayPicker.getValue();
        return date;
    }

    public int getDay() {
        return this.mCalendar.get(5);
    }

    public int getMonth() {
        return this.mCalendar.get(2);
    }

    public int getYear() {
        return this.mCalendar.get(1);
    }

    public void setCalendar(Calendar calendar) {
        this.mCalendar = calendar;
        this.updateDate();
    }
}

