/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.aot.graalvm;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import picocli.CommandLine;
import picocli.codegen.aot.graalvm.OutputFileMixin;

public class DynamicProxyConfigGenerator {
    public static void main(String ... args) {
        new CommandLine((Object)new App()).execute(args);
    }

    public static String generateProxyConfig(CommandLine.Model.CommandSpec[] specs, String[] interfaceClasses) {
        Visitor visitor = new Visitor(interfaceClasses);
        for (CommandLine.Model.CommandSpec spec : specs) {
            visitor.visitCommandSpec(spec);
        }
        return visitor.toString();
    }

    static final class Visitor {
        List<String> interfaces = new ArrayList<String>();
        List<String> commandInterfaces = new ArrayList<String>();

        Visitor(String[] interfaceClasses) {
            this.interfaces.addAll(Arrays.asList(interfaceClasses));
        }

        void visitCommandSpec(CommandLine.Model.CommandSpec spec) {
            Object userObject = spec.userObject();
            if (Proxy.isProxyClass(userObject.getClass())) {
                Class<?>[] interfaces = userObject.getClass().getInterfaces();
                String names = "";
                for (Class<?> interf : interfaces) {
                    if (names.length() > 0) {
                        names = names + ",";
                    }
                    names = names + interf.getCanonicalName();
                }
                if (names.length() > 0) {
                    this.commandInterfaces.add(names);
                }
            } else if (spec.userObject() instanceof Element && ((Element)spec.userObject()).getKind() == ElementKind.INTERFACE) {
                this.commandInterfaces.add(((Element)spec.userObject()).asType().toString());
            }
            for (CommandLine.Model.CommandSpec mixin : spec.mixins().values()) {
                this.visitCommandSpec(mixin);
            }
            for (CommandLine sub : spec.subcommands().values()) {
                this.visitCommandSpec(sub.getCommandSpec());
            }
        }

        public String toString() {
            return String.format("[%s%n]%n", this.all());
        }

        private StringBuilder all() {
            return Visitor.json(this.commandInterfaces, this.interfaces);
        }

        private static StringBuilder json(List<String> ... stringLists) {
            StringBuilder result = new StringBuilder(1024);
            for (List<String> list : stringLists) {
                for (String str : list) {
                    if (result.length() > 0) {
                        result.append(",");
                    }
                    String[] names = str.split(",");
                    String formatted = "";
                    for (String name : names) {
                        if (formatted.length() > 0) {
                            formatted = formatted + ", ";
                        }
                        formatted = formatted + '\"' + name + '\"';
                    }
                    result.append(String.format("%n  [%s]", formatted));
                }
            }
            return result;
        }
    }

    @CommandLine.Command(name="gen-proxy-config", description={"Generates a JSON file with the resources and resource bundles to include in the native image. The generated JSON file can be passed to the -H:DynamicProxyConfigurationFiles=/path/to/proxy-config.json option of the `native-image` GraalVM utility.", "See https://github.com/oracle/graal/blob/master/substratevm/DYNAMIC_PROXY.md"}, mixinStandardHelpOptions=true, version={"picocli-codegen gen-proxy-config 4.1.0"})
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="0..*", description={"Zero or more @Command interfaces or classes with @Command interface subcommands to generate a Graal SubstrateVM proxy-config for."})
        Class<?>[] classes = new Class[0];
        @CommandLine.Option(names={"-i", "--interface"}, description={"Other fully qualified interface names to generate dynamic proxy classes for in the native image.This option may be specified multiple times with different interface names. Specify multiple comma-separated interface names for dynamic proxies that implement multiple interfaces."})
        String[] interfaces = new String[0];
        @CommandLine.Mixin
        OutputFileMixin outputFile = new OutputFileMixin();

        private App() {
        }

        @Override
        public Integer call() throws IOException {
            ArrayList<CommandLine.Model.CommandSpec> specs = new ArrayList<CommandLine.Model.CommandSpec>();
            for (Class<?> cls : this.classes) {
                specs.add(new CommandLine(cls).getCommandSpec());
            }
            String result = DynamicProxyConfigGenerator.generateProxyConfig(specs.toArray(new CommandLine.Model.CommandSpec[0]), this.interfaces);
            this.outputFile.write(result);
            return 0;
        }
    }
}

