/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class TypeImporter {
    private static Set<String> javaDefaultTypes;
    private Set<String> registeredPackages = new HashSet<String>();
    private SortedSet<TypeName> imports = new TreeSet<TypeName>();

    public TypeImporter(String outputPackage) {
        this.registeredPackages.add(TypeImporter.makeValid(outputPackage));
    }

    private static String makeValid(String s) {
        StringBuilder result = new StringBuilder(s.length());
        int ch = 0;
        for (int i = 0; i < s.length(); i += Character.charCount(ch)) {
            ch = s.codePointAt(i);
            if (!Character.isJavaIdentifierPart(ch) && ch <= 32) continue;
            result.appendCodePoint(ch);
        }
        return result.toString();
    }

    public String getImportedName(String fullyQualifiedClass) {
        int i = fullyQualifiedClass.indexOf(60);
        if (i == -1) {
            return this.register(fullyQualifiedClass).getSimpleName();
        }
        StringBuilder result = new StringBuilder();
        int start = 0;
        int end = fullyQualifiedClass.length();
        while (i < end) {
            char c = fullyQualifiedClass.charAt(i);
            switch (c) {
                case '&': 
                case ',': 
                case '<': 
                case '>': 
                case '[': 
                case ']': {
                    if (start != i) {
                        String potentialClassName = fullyQualifiedClass.substring(start, i);
                        if (!this.isTypeVariable(potentialClassName)) {
                            Generic clean = new Generic(potentialClassName);
                            result.append(clean.specialization + this.register(clean.typeName).getSimpleName());
                        } else {
                            result.append(potentialClassName);
                        }
                    }
                    result.append(c);
                    start = i + 1;
                    break;
                }
                case '?': {
                    int j;
                    for (j = i + 1; j < end && Character.isWhitespace(fullyQualifiedClass.charAt(j)); ++j) {
                    }
                    if (j + 6 < end && "extends".equals(fullyQualifiedClass.substring(j, j + 7))) {
                        result.append(fullyQualifiedClass.substring(i, j + 7));
                        i = j + 6;
                    } else if (j + 4 < end && "super".equals(fullyQualifiedClass.substring(j, j + 5))) {
                        result.append(fullyQualifiedClass.substring(i, j + 5));
                        i = j + 4;
                    } else {
                        result.append(c);
                    }
                    start = i + 1;
                    break;
                }
                default: {
                    if (!Character.isWhitespace(c) || start != i) break;
                    result.append(c);
                    ++start;
                }
            }
            ++i;
        }
        return result.toString();
    }

    private boolean isTypeVariable(String potentialClassName) {
        return potentialClassName.length() == 1;
    }

    private TypeName register(String typeName) {
        return this.register(new TypeName(typeName));
    }

    private TypeName register(TypeName typeName) {
        String pkg = typeName.getPackageName();
        if (typeName.getSimpleName().equals("*")) {
            this.registeredPackages.add(pkg);
            this.imports.add(typeName);
        } else if (this.shouldImport(typeName)) {
            if ("".equals(pkg) && typeName.findMatchingSimpleName(this.imports) != null) {
                return typeName;
            }
            if (!this.registeredPackages.contains(pkg)) {
                this.imports.add(typeName);
            }
        }
        return typeName;
    }

    private boolean shouldImport(TypeName typeName) {
        String pkg = typeName.getPackageName();
        String simpleName = typeName.getSimpleName();
        boolean exclude = (pkg.equals("java.lang") || pkg.equals("")) && TypeImporter.getJavaDefaultTypes().contains(simpleName);
        return !exclude;
    }

    static Set<String> getJavaDefaultTypes() {
        if (javaDefaultTypes == null) {
            javaDefaultTypes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AbstractMethodError", "Appendable", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "AssertionError", "AutoCloseable", "Boolean", "BootstrapMethodError", "Byte", "Character", "CharSequence", "Class", "ClassCastException", "ClassCircularityError", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "ClassValue", "Cloneable", "CloneNotSupportedException", "Comparable", "Compiler", "Deprecated", "Double", "Enum", "EnumConstantNotPresentException", "Error", "Exception", "ExceptionInInitializerError", "Float", "FunctionalInterface", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalCallerException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IncompatibleClassChangeError", "IndexOutOfBoundsException", "InheritableThreadLocal", "InstantiationError", "InstantiationException", "Integer", "InternalError", "InterruptedException", "Iterable", "LayerInstantiationException", "LinkageError", "Long", "Math", "Module", "ModuleLayer", "NegativeArraySizeException", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchFieldException", "NoSuchMethodError", "NoSuchMethodException", "NullPointerException", "Number", "NumberFormatException", "Object", "OutOfMemoryError", "Override", "Package", "Process", "ProcessBuilder", "ProcessHandle", "Readable", "ReflectiveOperationException", "Runnable", "Runtime", "RuntimeException", "RuntimePermission", "SafeVarargs", "SecurityException", "SecurityManager", "Short", "StackOverflowError", "StackTraceElement", "StackWalker", "StrictMath", "String", "StringBuffer", "StringBuilder", "StringIndexOutOfBoundsException", "SuppressWarnings", "System", "Thread", "ThreadDeath", "ThreadGroup", "ThreadLocal", "Throwable", "TypeNotPresentException", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "UnsupportedOperationException", "VerifyError", "VirtualMachineError", "Void", "boolean", "byte", "char", "double", "float", "int", "long", "short", "void")));
        }
        return javaDefaultTypes;
    }

    public String createImportDeclaration() {
        return this.createImportDeclaration(System.getProperty("line.separator"));
    }

    public String createImportDeclaration(String lineDelimiter) {
        StringBuilder result = new StringBuilder();
        for (TypeName importName : this.getImports()) {
            result.append(lineDelimiter + "import " + importName + ";");
        }
        return result.toString();
    }

    private SortedSet<TypeName> getImports() {
        this.compactImports();
        return this.imports;
    }

    private void compactImports() {
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            TypeName importName = (TypeName)i.next();
            if (importName.getSimpleName().equals("*") || !this.registeredPackages.contains(importName.getPackageName())) continue;
            i.remove();
        }
    }

    static class Generic {
        String specialization = "";
        String typeName;

        Generic(String name) {
            this.typeName = name;
            int i = name.indexOf("extends");
            if (i > 0 && Character.isWhitespace(name.charAt(i - 1)) && Character.isWhitespace(name.charAt(i + "extends".length()))) {
                this.typeName = name.substring(i + "extends".length()).trim();
                this.specialization = name.substring(0, name.indexOf(this.typeName));
            }
            if ((i = name.indexOf("super")) > 0 && Character.isWhitespace(name.charAt(i - 1)) && Character.isWhitespace(name.charAt(i + "super".length()))) {
                this.typeName = name.substring(i + "super".length()).trim();
                this.specialization = name.substring(0, name.indexOf(this.typeName));
            }
        }
    }

    static class TypeName
    implements Comparable<TypeName> {
        private final String qualifiedName;
        private final String packageName;
        private final String simpleName;
        private final String importName;

        TypeName(String qualifiedName) {
            this.qualifiedName = qualifiedName;
            String canonical = qualifiedName.replaceAll("\\$", ".");
            int dot = canonical.lastIndexOf(46);
            this.packageName = dot == -1 ? "" : TypeImporter.makeValid(canonical.substring(0, dot));
            int from = dot + 1;
            int end = canonical.indexOf(91, from);
            if (end == -1) {
                end = canonical.length();
            }
            this.simpleName = TypeImporter.makeValid(canonical.substring(from, end));
            this.importName = dot == -1 ? this.simpleName : this.packageName + "." + this.simpleName;
        }

        private String getPackageName() {
            return this.packageName;
        }

        private String getSimpleName() {
            return this.simpleName;
        }

        public String getImportName() {
            return this.importName;
        }

        @Override
        public int compareTo(TypeName o) {
            return this.qualifiedName.compareTo(o.qualifiedName);
        }

        public String toString() {
            return this.qualifiedName;
        }

        public TypeName findMatchingSimpleName(Collection<TypeName> imports) {
            for (TypeName typeName : imports) {
                if (!typeName.getSimpleName().equals(this.getSimpleName())) continue;
                return typeName;
            }
            return null;
        }
    }
}

