/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.config.TokenAuthorisation;
import info.movito.themoviedbapi.model.config.TokenSession;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.MovieDbException;

public class TmdbAuthentication
extends AbstractTmdbApi {
    public static final String PARAM_REQUEST_TOKEN = "request_token";
    public static final String TMDB_METHOD_AUTH = "authentication";

    TmdbAuthentication(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public TokenAuthorisation getAuthorisationToken() {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "token/new");
        return this.mapJsonResult(apiUrl, TokenAuthorisation.class);
    }

    public TokenSession getSessionToken(TokenAuthorisation token) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "session/new");
        if (!token.getSuccess().booleanValue()) {
            this.logger.warn("Authorisation token was not successful!");
            throw new MovieDbException("Authorisation token was not successful!");
        }
        apiUrl.addParam(PARAM_REQUEST_TOKEN, token.getRequestToken());
        return this.mapJsonResult(apiUrl, TokenSession.class);
    }

    public TokenAuthorisation getLoginToken(TokenAuthorisation token, String user, String pwd) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "token/validate_with_login");
        apiUrl.addParam(PARAM_REQUEST_TOKEN, token.getRequestToken());
        apiUrl.addParam("username", user);
        apiUrl.addParam("password", pwd);
        return this.mapJsonResult(apiUrl, TokenAuthorisation.class);
    }

    public TokenSession getSessionLogin(String username, String password) {
        TokenAuthorisation authToken = this.getAuthorisationToken();
        if (!authToken.getSuccess().booleanValue()) {
            throw new MovieDbException("Authorisation token was not successful!");
        }
        TokenAuthorisation loginToken = this.getLoginToken(authToken, username, password);
        if (!loginToken.getSuccess().booleanValue()) {
            throw new MovieDbException("User authentication failed:" + loginToken.toString());
        }
        return this.getSessionToken(loginToken);
    }

    public TokenSession getGuestSessionToken() {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_AUTH, "guest_session/new");
        return this.mapJsonResult(apiUrl, TokenSession.class);
    }
}

