/*
 * Decompiled with CFR 0.152.
 */
package info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.pool;

import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.Kryo;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.pool.KryoCallback;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.pool.KryoFactory;
import info.jerrinot.subzero.relocated.com.esotericsoftware.kryo.pool.KryoPool;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KryoPoolQueueImpl
implements KryoPool {
    private final Queue<Kryo> queue;
    private final KryoFactory factory;

    KryoPoolQueueImpl(KryoFactory factory, Queue<Kryo> queue) {
        this.factory = factory;
        this.queue = queue;
    }

    public int size() {
        return this.queue.size();
    }

    @Override
    public Kryo borrow() {
        Kryo res = this.queue.poll();
        if (res != null) {
            return res;
        }
        return this.factory.create();
    }

    @Override
    public void release(Kryo kryo) {
        this.queue.offer(kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(KryoCallback<T> callback) {
        Kryo kryo = this.borrow();
        try {
            T t = callback.execute(kryo);
            return t;
        }
        finally {
            this.release(kryo);
        }
    }

    public void clear() {
        this.queue.clear();
    }
}

