/*
 * Decompiled with CFR 0.152.
 */
package info.jerrinot.subzero.internal;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderUtils {
    private static final boolean DEBUG_CLASSLOADING = Boolean.getBoolean("subzero.debug.classloading");

    public static ClassLoader getConfiguredClassLoader(HazelcastInstance hz) {
        try {
            return ClassLoaderUtils.tryToGetClassLoader(hz);
        }
        catch (RuntimeException e) {
            if (DEBUG_CLASSLOADING) {
                throw e;
            }
            return null;
        }
    }

    private static ClassLoader tryToGetClassLoader(HazelcastInstance hz) {
        try {
            Config config = hz.getConfig();
            return config.getClassLoader();
        }
        catch (UnsupportedOperationException e) {
            try {
                Method getClientConfigMethod = hz.getClass().getMethod("getClientConfig", new Class[0]);
                ClientConfig clientConfig = (ClientConfig)getClientConfigMethod.invoke((Object)hz, new Object[0]);
                return clientConfig.getClassLoader();
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException("Unknown instance object " + hz, e1);
            }
            catch (IllegalAccessException e1) {
                throw new IllegalArgumentException("Unknown instance object " + hz, e1);
            }
            catch (InvocationTargetException e1) {
                throw new IllegalArgumentException("Unknown instance object " + hz, e1);
            }
        }
    }
}

