/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.xq;

import info.freelibrary.util.DOMUtils;
import info.freelibrary.util.IOUtils;
import info.freelibrary.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Put {
    private static final String XML_CONTENT_TYPE = "application/xml; charset=utf-8";
    private static final String XQ_MIME_TYPE = "application/xquery xq xql xquery";
    private static final String EOL = System.getProperty("line.separator");
    private static final String CHARSET = "UTF-8";

    public static Element put(String aFileName, String aURL) throws FileNotFoundException, IOException {
        return Put.put(new File(aFileName), new URL(aURL));
    }

    public static Element put(String aFileName, URL aURL) throws IOException {
        return Put.put(new File(aFileName), aURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element put(File aFile, URL aURL) throws IOException {
        Reader reader;
        MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
        fileTypeMap.addMimeTypes(XQ_MIME_TYPE);
        String contentType = fileTypeMap.getContentType(aFile);
        HttpURLConnection http = Put.connect(aURL, contentType);
        StringBuilder response = new StringBuilder();
        OutputStream out = http.getOutputStream();
        BufferedWriter bWriter = null;
        try {
            bWriter = new BufferedWriter(new OutputStreamWriter(out, CHARSET));
            bWriter.write(StringUtils.read(aFile));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bWriter);
            throw throwable;
        }
        IOUtils.closeQuietly(bWriter);
        int responseCode = http.getResponseCode();
        String responseMessage = http.getResponseMessage();
        if (responseCode == 200) {
            BufferedReader bReader = null;
            InputStream in = http.getInputStream();
            reader = new InputStreamReader(in, CHARSET);
            try {
                String line;
                bReader = new BufferedReader(reader);
                while ((line = bReader.readLine()) != null) {
                    response.append(line + EOL);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bReader);
                throw throwable;
            }
            IOUtils.closeQuietly(bReader);
        }
        if (response.length() == 0) {
            response.append("<empty/>");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            reader = new StringReader(response.toString());
            Document doc = docBuilder.parse(new InputSource(reader));
            String codeAsText = Integer.toString(responseCode);
            Element root = doc.getDocumentElement();
            root.setAttribute("responseCode", codeAsText);
            root.setAttribute("responseMessage", responseMessage);
            return root;
        }
        catch (ParserConfigurationException details) {
            throw new RuntimeException(details);
        }
        catch (SAXException details) {
            throw new RuntimeException(details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element put(URL aURL, Element aElement) throws IOException {
        Reader reader;
        HttpURLConnection http = Put.connect(aURL, XML_CONTENT_TYPE);
        StringBuilder response = new StringBuilder();
        int responseCode = Put.writeXML(aElement, http);
        if (responseCode == 200) {
            BufferedReader bReader = null;
            try {
                String line;
                InputStream in = http.getInputStream();
                reader = new InputStreamReader(in, CHARSET);
                bReader = new BufferedReader(reader);
                while ((line = bReader.readLine()) != null) {
                    response.append(line).append(EOL);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bReader);
                throw throwable;
            }
            IOUtils.closeQuietly(bReader);
        }
        if (response.length() == 0) {
            response.append("<empty/>");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            reader = new StringReader(response.toString());
            Document doc = docBuilder.parse(new InputSource(reader));
            String codeAsText = Integer.toString(responseCode);
            Element root = doc.getDocumentElement();
            root.setAttribute("responseCode", codeAsText);
            return root;
        }
        catch (ParserConfigurationException details) {
            throw new RuntimeException(details);
        }
        catch (SAXException details) {
            throw new RuntimeException(details);
        }
    }

    private static HttpURLConnection connect(URL aURL, String aContentType) throws IOException {
        HttpURLConnection http = (HttpURLConnection)aURL.openConnection();
        http.setDoOutput(true);
        http.setRequestMethod("PUT");
        http.setRequestProperty("content-type", aContentType);
        http.connect();
        return http;
    }

    private static final int writeXML(Element aNode, HttpURLConnection aConx) throws IOException {
        BufferedWriter bWriter = null;
        try {
            OutputStream out = aConx.getOutputStream();
            bWriter = new BufferedWriter(new OutputStreamWriter(out, CHARSET));
            bWriter.write(DOMUtils.toXML(aNode));
        }
        catch (TransformerException details) {
            try {
                throw new IOException(details);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bWriter);
        return aConx.getResponseCode();
    }
}

