/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.xq;

import info.freelibrary.util.DOMUtils;
import info.freelibrary.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Post {
    private static final String CONTENT_TYPE = "application/xml; charset=utf-8";
    private static final String EOL = System.getProperty("line.separator");
    private static final String CHARSET = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Element post(URL aURL, Element aNode) throws IOException {
        Reader reader;
        StringBuilder response = new StringBuilder();
        HttpURLConnection http = Post.connect(aURL);
        int responseCode = Post.write(aNode, http);
        if (responseCode == 200) {
            BufferedReader bReader = null;
            try {
                String line;
                InputStream in = http.getInputStream();
                reader = new InputStreamReader(in, CHARSET);
                bReader = new BufferedReader(reader);
                while ((line = bReader.readLine()) != null) {
                    response.append(line + EOL);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bReader);
                throw throwable;
            }
            IOUtils.closeQuietly(bReader);
        }
        if (response.length() == 0) {
            response.append("<empty/>");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            reader = new StringReader(response.toString());
            Document doc = docBuilder.parse(new InputSource(reader));
            String codeAsText = Integer.toString(responseCode);
            Element root = doc.getDocumentElement();
            root.setAttribute("responseCode", codeAsText);
            return root;
        }
        catch (ParserConfigurationException details) {
            throw new RuntimeException(details);
        }
        catch (SAXException details) {
            throw new RuntimeException(details);
        }
    }

    private static final HttpURLConnection connect(URL aHttpURL) throws IOException {
        HttpURLConnection http = (HttpURLConnection)aHttpURL.openConnection();
        http.setDoInput(true);
        http.setDoOutput(true);
        http.setRequestProperty("content-type", CONTENT_TYPE);
        http.connect();
        return http;
    }

    private static final int write(Element aNode, HttpURLConnection aHttpConn) throws IOException {
        BufferedWriter bWriter = null;
        try {
            OutputStream out = aHttpConn.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out, CHARSET);
            bWriter = new BufferedWriter(writer);
            bWriter.write(DOMUtils.toXML(aNode));
        }
        catch (TransformerException details) {
            try {
                throw new IOException(details);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bWriter);
        return aHttpConn.getResponseCode();
    }
}

