/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class StringUtils {
    public static final String UTF_8 = "UTF-8";

    private StringUtils() {
    }

    public static String trimToNull(Object aStringObj) {
        return StringUtils.trimTo(aStringObj, null);
    }

    public static boolean trimToBool(Object aStringObj, boolean aBool) {
        try {
            String boolString = StringUtils.trimTo(aStringObj, Boolean.toString(aBool));
            return Boolean.parseBoolean(boolString);
        }
        catch (ClassCastException details) {
            return aBool;
        }
    }

    public static String trimTo(Object aString, String aDefault) {
        if (aString == null) {
            return aDefault;
        }
        String trimmed = ((String)aString).trim();
        return trimmed.length() == 0 ? aDefault : trimmed;
    }

    public static String format(String aMessage, Object ... aDetail) {
        return StringUtils.format(aMessage, StringUtils.toStrings(aDetail));
    }

    public static String format(String aMessage, String ... aDetails) {
        int position = 0;
        int count = 0;
        while ((position = aMessage.indexOf("{}", position)) != -1) {
            ++position;
            ++count;
        }
        if (count != aDetails.length) {
            throw new IndexOutOfBoundsException("Different number of slots and values: " + count + " and " + aDetails.length);
        }
        String[] parts = aMessage.split("\\{\\}");
        StringBuilder builder = new StringBuilder();
        if (count == 1 && parts.length == 0) {
            builder.append(aDetails[0]);
        } else {
            for (int index = 0; index < parts.length; ++index) {
                builder.append(parts[index]);
                if (index >= aDetails.length) continue;
                builder.append(aDetails[index]);
            }
        }
        return builder.length() == 0 ? aMessage : builder.toString();
    }

    public static String[] toStrings(Object ... aVarargs) {
        String[] strings = new String[aVarargs.length];
        for (int index = 0; index < strings.length; ++index) {
            strings[index] = aVarargs[index].toString();
        }
        return strings;
    }

    public static String normalizeWS(String aMessage) {
        return aMessage.replaceAll("\\s+", " ");
    }

    public static String padStart(String aString, String aPadding, int aRepeatCount) {
        if (aRepeatCount != 0) {
            StringBuilder buffer = new StringBuilder();
            for (int index = 0; index < aRepeatCount; ++index) {
                buffer.append(aPadding);
            }
            return buffer.append(aString).toString();
        }
        return aString;
    }

    public static String padEnd(String aString, String aPadding, int aRepeatCount) {
        if (aRepeatCount != 0) {
            StringBuilder buffer = new StringBuilder(aString);
            for (int index = 0; index < aRepeatCount; ++index) {
                buffer.append(aPadding);
            }
            return buffer.toString();
        }
        return aString;
    }

    public static String toCharCount(String aString, int aCount) {
        StringBuilder builder = new StringBuilder();
        String[] words = aString.split("\\s");
        int count = 0;
        for (String word : words) {
            if ((count += word.length()) < aCount) {
                builder.append(word);
                if (++count < aCount) {
                    builder.append(' ');
                    continue;
                }
                builder.append("\r\n  ");
                count = 2;
                continue;
            }
            builder.append("\r\n  ").append(word);
            count = word.length() + 2;
        }
        return builder.toString();
    }

    public static String repeat(String aValue, int aRepeatCount) {
        StringBuilder buffer = new StringBuilder();
        for (int index = 0; index < aRepeatCount; ++index) {
            buffer.append(aValue);
        }
        return buffer.toString();
    }

    public static String repeat(char aChar, int aRepeatCount) {
        StringBuilder buffer = new StringBuilder();
        for (int index = 0; index < aRepeatCount; ++index) {
            buffer.append(aChar);
        }
        return buffer.toString();
    }

    public static String read(File aFile, String aCharsetName) throws IOException {
        return StringUtils.read(aFile, Charset.forName(aCharsetName));
    }

    public static String read(File aFile, Charset aCharset) throws IOException {
        String string = new String(StringUtils.readBytes(aFile), aCharset);
        if (string.endsWith(System.getProperty("line.separator"))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String read(File aFile) throws IOException {
        String string = new String(StringUtils.readBytes(aFile), UTF_8);
        if (string.endsWith(System.getProperty("line.separator"))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String[] trim(String ... aStringArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : aStringArray) {
            if (string == null || string.equals("")) continue;
            list.add(string);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String toString(char aPadChar, Object ... aVarargs) {
        return StringUtils.toString(aVarargs, aPadChar);
    }

    public static String toString(Object[] aObjArray, char aPadChar) {
        if (aObjArray.length == 0) {
            return "";
        }
        if (aObjArray.length == 1) {
            return aObjArray[0].toString();
        }
        StringBuilder buffer = new StringBuilder();
        for (Object obj : aObjArray) {
            buffer.append(obj.toString()).append(aPadChar);
        }
        return buffer.deleteCharAt(buffer.length() - 1).toString();
    }

    public static String toString(Map<String, String[]> aMap) {
        Set<Map.Entry<String, String[]>> set = aMap.entrySet();
        Iterator<Map.Entry<String, String[]>> setIter = set.iterator();
        StringBuilder buffer = new StringBuilder();
        while (setIter.hasNext()) {
            Map.Entry<String, String[]> entry = setIter.next();
            String[] values = entry.getValue();
            buffer.append(entry.getKey()).append('=');
            for (String value : values) {
                buffer.append('{').append(value).append('}');
            }
            buffer.append('&');
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '&') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static String addLineNumbers(String aMessage) {
        String eol = System.getProperty("line.separator");
        String[] lines = aMessage.split(eol);
        StringBuilder buffer = new StringBuilder();
        int lineCount = 1;
        for (String line : lines) {
            buffer.append(lineCount++).append(' ').append(line);
            buffer.append(eol);
        }
        int length = buffer.length();
        buffer.delete(length - eol.length(), length);
        return buffer.toString();
    }

    private static byte[] readBytes(File aFile) throws IOException {
        FileInputStream fileStream = new FileInputStream(aFile);
        ByteBuffer buf = ByteBuffer.allocate((int)aFile.length());
        int read = fileStream.getChannel().read(buf);
        if ((long)read != aFile.length()) {
            fileStream.close();
            throw new IOException("Failed to read whole file");
        }
        fileStream.close();
        return buf.array();
    }

    public static int[] parseIntRange(String aIntRange) {
        int[] ints;
        String[] range = aIntRange.split("-");
        if (range.length == 1) {
            ints = new int[range.length];
            ints[0] = Integer.parseInt(aIntRange);
        } else {
            int start = Integer.parseInt(range[0]);
            int end = Integer.parseInt(range[1]);
            if (end >= start) {
                int position = 0;
                int size = end - start;
                ints = new int[size + 1];
                int index = start;
                while (index <= end) {
                    ints[position++] = index++;
                }
            } else {
                throw new NumberFormatException("Inverted number range: " + start + "-" + end);
            }
        }
        return ints;
    }

    public static String toString(int aInt) {
        return StringUtils.toUpcaseString(aInt).toLowerCase(Locale.getDefault());
    }

    public static String reverse(String aString) {
        return new StringBuffer(aString).reverse().toString();
    }

    public static String toUpcaseString(int aInt) {
        switch (aInt) {
            case 1: {
                return "First";
            }
            case 2: {
                return "Second";
            }
            case 3: {
                return "Third";
            }
            case 4: {
                return "Fourth";
            }
            case 5: {
                return "Fifth";
            }
            case 6: {
                return "Sixth";
            }
            case 7: {
                return "Seventh";
            }
            case 8: {
                return "Eighth";
            }
            case 9: {
                return "Ninth";
            }
            case 10: {
                return "Tenth";
            }
            case 11: {
                return "Eleventh";
            }
            case 12: {
                return "Twelveth";
            }
            case 13: {
                return "Thirteenth";
            }
            case 14: {
                return "Fourteenth";
            }
            case 15: {
                return "Fifthteenth";
            }
            case 16: {
                return "Sixteenth";
            }
            case 17: {
                return "Seventeenth";
            }
            case 18: {
                return "Eighteenth";
            }
            case 19: {
                return "Nineteenth";
            }
            case 20: {
                return "Twentieth";
            }
        }
        throw new UnsupportedOperationException("Don't have a string value for " + aInt);
    }
}

